/**This program is to practice GTK by creating a creating smiley with GtkImage Widget
  * @author Saurabh Barjatiya
  * @version 1.0
  * @file 07-gtk_image.c
  *
  */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>


/**This is where program starts and generates a smiley with GtkImage.
  * @param argc Number of arguments passed to program
  * @param argv Array of arugments passed to program
  * @returns EXIT_SUCCESS if program exits properly, EXIT_FAILURE otherwise.
  *
  */
int main(int argc, char *argv[])
{
    GtkWidget *window;
    GtkWidget *image;

    gtk_init(&argc, &argv);
    
    window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "07-gtk_image example");
    gtk_window_set_default_size(GTK_WINDOW(window),340,200);

    image = gtk_image_new_from_file("smiley.png");
    gtk_container_add(GTK_CONTAINER(window), image);

    g_signal_connect(G_OBJECT(window), "delete_event", G_CALLBACK(gtk_main_quit), NULL);

    gtk_widget_show(image);
    gtk_widget_show(window);
    gtk_main();

    return EXIT_SUCCESS;
}




