/**This program is a GTK interface for E LIBRARY.
  *It is an implementation through GTK for interface interactions
  *and Sqlite3 for database management that allows users to
  *open files of pdf format 
  * @author Vedavyas Garimella
  * @version 1.0
  * @file elib.c
  */



#include <string.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sqlite3.h>
#include <sys/types.h>
#include <unistd.h>


#define BUFFER 4096
#define MAX_IMAGES 8


    sqlite3 *db1;

    GtkWidget *dialog, *table, *user, *real, *home;
    GtkWidget *lbl1, *lbl2, *lbl3;
    GtkWidget  *button,*addbutton,*deletebutton;

    char filename[1000];                                            // Stores the file name
    char filepath[100];                                             // Stores the path of file


/**
  *Standard callback function used to display the results in Sqlite3
  */

static int callback (void *NotUsed, int argc, char **argv, char **azColName)
{
    NotUsed = 0;
    int i;
    for (i = 0; i < argc; i++)
    {
		printf ("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");	
    }
    printf ("\n");
    return 0;
}


/**
  * Function sets up the database tables, in Sqlite and fills in tha data in them.
  * It creates a new database if such a database is missing, or
  * appends to the tables if it exists.
  */
  
void setup_tables()
{
    int rc1;
    char *zErrMsg = 0;
    char sql_query[BUFFER];                                                     // Query Statement storage variable.
    rc1 = sqlite3_open ("mylibrary.sqlite", &db1);
    if (rc1)
    {
		fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db1));
		sqlite3_close (db1);
		exit (1);
    }

    
    strcpy(sql_query, "create table mylibrary (bookname,authorname,path)");
    rc1 = sqlite3_exec (db1, sql_query, callback, 0, &zErrMsg);
}


 
/**
  *This funtion consists of the action that is to be performed 
  *when View button is clicked in the Main Window.
  */
  
  
gint view_button(GtkWidget *widget, GdkEvent *event, gpointer value)
{        

    GtkWidget *dialog1;
    GSList *filenames;
    
    dialog1 = gtk_file_chooser_dialog_new ("View File(s) ",(GtkWindow *)dialog,GTK_FILE_CHOOSER_ACTION_OPEN,GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,NULL);                                              // Dialogue for Viewfiles



    gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (dialog1), FALSE);           // Disabling opening of multiple files
    gint result = gtk_dialog_run (GTK_DIALOG (dialog1));

    char fname[100];

    if (result == GTK_RESPONSE_ACCEPT)
    {
        filenames = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (dialog1));

        while (filenames != NULL)
        {
                gchar *file = (gchar*) filenames->data;                                 // Saving the file path of the selected file
                g_print ("%s was selected.\n", file);
                strcpy(fname,file);
                filenames = filenames->next;
        }
}

    gtk_widget_destroy (dialog1);


    //TODO:open file here
    char command[100];
    int pid=fork();

        if(!pid)
        {
                sprintf(command,"evince %s",fname);
                printf("%s\n",command);
                system(command);
                printf("Opening \n");
        }
        
    return FALSE;        
}

/**
  *This funtion consists of the action that is to be performed 
  *when Add button is clicked in the Main Window.
  */
  
  
gint add_button(GtkWidget *widget, GdkEvent *event, gpointer value)
{
        printf("%s\n\n",gtk_entry_get_text(GTK_ENTRY(home)));        
        FILE *fp = fopen(gtk_entry_get_text(GTK_ENTRY(home)),"r");
        if( !fp ) 
        {
                        //pop up a msg dialog
            GtkWidget *dialog2 = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "FILE DOESNT EXIST");
			gtk_dialog_run (GTK_DIALOG (dialog2));
			gtk_widget_destroy (dialog2); 		
 	    
 	        return FALSE;
        
        }
                        //add file,author,path to DB
    int NotUsed = 0;
    char *zErrMsg = 0;
    int rc;
    char sql_query[BUFFER];
          
     sprintf(sql_query, "INSERT into mylibrary values('%s','%s','%s')",
     gtk_entry_get_text(GTK_ENTRY(user)),
     gtk_entry_get_text(GTK_ENTRY(real)),
     gtk_entry_get_text(GTK_ENTRY(home)));
        
        printf("%s\n",sql_query);
             rc = sqlite3_exec (db1, sql_query, callback, 0, &zErrMsg);
      printf("%d",rc);  
     if (rc != SQLITE_OK)
    {

	fprintf (stderr, "SQL error: %s\n", zErrMsg);
	// This will free zErrMsg if assigned 
	//if (zErrMsg)
      //  free (zErrMsg);

    }
    else
    {
	printf("Record stored successfully.\n");

    }
   
        
     //cp file to const-path with name author-bookname
     
     char command[100],dest[200];

     sprintf(dest,"%s%s-%s.pdf",filepath,gtk_entry_get_text(GTK_ENTRY(user)),gtk_entry_get_text(GTK_ENTRY(real)));    

     sprintf(command,"cp '%s' '%s'",gtk_entry_get_text(GTK_ENTRY(home)),dest);
     printf("destination:%s\n",dest);
     
     system(command);  
     printf("Adding file to HD\n");
     
     return FALSE;

}


/**
  *This funtion consists of the action that is to be performed 
  *when Delete button is clicked in the Main Window.
  */


gint delete_button(GtkWidget *widget, GdkEvent *event, gpointer value)
{
         
         
            //TODO:delete from harddisk
     char command[100],filename[100];
             
     sprintf(filename,"%s%s-%s.pdf",filepath,gtk_entry_get_text(GTK_ENTRY(user)),gtk_entry_get_text(GTK_ENTRY(real)));
     printf("FILENAME:%s\n",filename);

     sprintf(command,"rm %s",filename);
     printf("%s \n",command);
     FILE *fp = fopen(filename,"r");
     if( !fp )
     {
                        //pop up a msg dialog
            GtkWidget *dialog2 = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "FILE DOESNT EXIST");
			gtk_dialog_run (GTK_DIALOG (dialog2));
			gtk_widget_destroy (dialog2); 		
 	 
 	        return FALSE;
     }
         
            //delete from db
     int NotUsed = 0;
     char *zErrMsg = 0;
     int rc;
     char sql_query[BUFFER];
           
     sprintf(sql_query, "DELETE from mylibrary where bookname='%s' and authorname='%s'",
            gtk_entry_get_text(GTK_ENTRY(user)),
            gtk_entry_get_text(GTK_ENTRY(real)));
         
     rc = sqlite3_exec (db1, sql_query, callback, 0, &zErrMsg);
            
     system(command);  
     
     printf("Deleting file from  HD\n");
     
     return FALSE;
}

/**
  *This is the main function of the program.
  *This function is mostly used to create the interface for the application.
  *This contains all the buttons , dialogs and labels. 
  */
  
  
int main (int argc,char *argv[])
{
    gint result;
    gtk_init (&argc, &argv);

    dialog = gtk_dialog_new_with_buttons ("E LIBRARY", NULL,GTK_DIALOG_MODAL,GTK_STOCK_OK, GTK_RESPONSE_OK,GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,NULL);
    gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);

/* Create four entries that will tell the user what data to enter. */
    lbl1 = gtk_label_new ("Book Name:");
    lbl2 = gtk_label_new ("Author Name:");
    lbl3 = gtk_label_new ("Path:");

    strcpy(filepath,"/home/garimella/elib/");
    setup_tables();


    user = gtk_entry_new ();
    real = gtk_entry_new ();
    home = gtk_entry_new ();

    button = gtk_button_new_with_label ("View Books");
    addbutton = gtk_button_new_with_label ("Add Book");
    deletebutton = gtk_button_new_with_label ("Delete Book");

        
    g_signal_connect (G_OBJECT (button),"clicked",G_CALLBACK(view_button),NULL);// 
    g_signal_connect (G_OBJECT (addbutton),"clicked",G_CALLBACK(add_button),NULL);// 
	g_signal_connect (G_OBJECT (deletebutton),"clicked",G_CALLBACK(delete_button),NULL);// 
	

/* Retrieve the user's information for the default values. */

    gtk_entry_set_text (GTK_ENTRY (user), g_get_user_name());
    gtk_entry_set_text (GTK_ENTRY (real), g_get_real_name());
    gtk_entry_set_text (GTK_ENTRY (home), g_get_home_dir());

    table = gtk_table_new (6, 2, FALSE);
    gtk_table_attach_defaults (GTK_TABLE (table), lbl1, 0, 1, 0, 1);
    gtk_table_attach_defaults (GTK_TABLE (table), lbl2, 0, 1, 1, 2);
    gtk_table_attach_defaults (GTK_TABLE (table), lbl3, 0, 1, 2, 3);

    gtk_table_attach_defaults (GTK_TABLE (table), user, 1, 2, 0, 1);
    gtk_table_attach_defaults (GTK_TABLE (table), real, 1, 2, 1, 2);
    gtk_table_attach_defaults (GTK_TABLE (table), home, 1, 2, 2, 3);
    gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 2, 3, 4);
    gtk_table_attach_defaults (GTK_TABLE (table), addbutton, 1, 2, 4, 5);
    gtk_table_attach_defaults (GTK_TABLE (table), deletebutton, 1, 2, 5, 6);

    gtk_table_set_row_spacings (GTK_TABLE (table), 5);
    gtk_table_set_col_spacings (GTK_TABLE (table), 5);
    gtk_container_set_border_width (GTK_CONTAINER (table), 5);


    gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (dialog)->vbox), table);
    gtk_widget_show_all (dialog);

/* Run the dialog and output the data if the user clicks the OK button. */
    result = gtk_dialog_run (GTK_DIALOG (dialog));
  
    if (result == GTK_RESPONSE_OK)
    {
        g_print ("User Name: %s\n", gtk_entry_get_text (GTK_ENTRY (user)));
        g_print ("Home Folder: %s\n", gtk_entry_get_text (GTK_ENTRY (home)));
        g_print ("Real Name: %s\n", gtk_entry_get_text (GTK_ENTRY (real)));
    }

    gtk_widget_destroy (dialog);

    return 0;

}
