/** This program is created to build an assignment submission system. It creates a window
 * with entry fields in it which to display questions and student can type their answer within it. 
 * Students can submit their assigment using this system and also can view their previous assignment.
 * Admin can create questions to the database system, view and edit current questions and also can view the list
 * of students that already submitted the assignment.
 * @file assignment_submission.c
 * @author Khairiyyah Binti Mohd Noor
 */


#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtk/gtksignal.h>
#include <gtk/gtktable.h>
#include <gtk/gtktogglebutton.h>
#include "connect.h"
#include<mysql/mysql.h>
#include<string.h>

MYSQL *connection1;
MYSQL_RES *result;
MYSQL_ROW sqlrow;

#define BUFFER 4096
#define MAX_FORMAT_SIZE 100

GtkWidget *view;
GtkWidget *view1;
GtkWidget *view2;
GtkWidget *viewQuest; 
GtkWidget *viewQuest1;
GtkWidget *viewStudent;
GtkWidget *buttonSubmit;
GtkTextBuffer *buffer;
GtkTextBuffer *buffer1;
GtkTextBuffer *buffer2;
GtkTextBuffer *buffer3;
GtkTextIter iter;
GtkToggleButton *button;
GtkWidget *window1;
GtkWidget *window2;
GtkWidget *window3;
GtkWidget *parent_window;
GtkEntry *name_entry;
GtkEntry *name_entry1;
GtkEntry *assig_no;
GtkEntry *assig_no1;
GtkEntry *assig_no2;
GtkEntry *quest_no;
GtkEntry *username_entry, *password_entry, *email_entry, *rollNo_entry;
GtkEntry *username_entry1, *password_entry1, *email_entry1, *rollNo_entry1;
GtkWidget *label_D;

/** It is called when user close/quit window using window manager.
 * We will always enable closing of window using window manager.
 * @param widget Widget which generated the event
 * @param data any additional data passed while generating signal
 * @return FALSE if you want to closing, TRUE otherwise
 */
gint close_application( GtkWidget *widget,gpointer   data )
{
  gtk_main_quit();
  return(FALSE);
}

/** It is called when user click button cancel 
 *to exit from the system.
 * @param widget Widget which generated the event
 * @param data any additional data passed while generating signal
 */
void button_Cancel(GtkWidget *widget,gpointer   data)
{
	exit(EXIT_SUCCESS);
}
/** This function is called when student or admin choose to login to the system
 * using login_interface and if login success will make the student access to the
 * assignment_interface while admin access to the admin_interface.
 * This function will connect to the database and access register table
 * to match the correct user.
 */
void button_ok_login()
{
	char sql_statement[BUFFER];
	int result_value;

        const char *username =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)username_entry));
        const char *password =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)password_entry));


    	connection1=mysql_init (NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
		sprintf(sql_statement,"select name from register where email = '%s' and password = '%s'",username,password);

		result_value = mysql_query (connection1, sql_statement);
	
		if (result_value)
		{
			printf ("select failed as : %s\n", mysql_error (connection1));
			printf ("Password Incorrect\n");
		
		
		}
		else
		{
	    		result = mysql_use_result (connection1);
	    		if (result)
	    		{
				while ((sqlrow = mysql_fetch_row (result)))
				{
		    			display_row3 ();
					assignment_interface();
					
				}
				if(strstr(username,"admin"))
				{
					if(strstr(password,"123"))
						admin_interface();
				}
	    		}
		
			
	    		mysql_free_result(result);
		}
  	 }

    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
		exit(EXIT_FAILURE);
    	}

}
/** It is called when student or admin choose to logout from the system
 */
void button_Logout()
{   
	gtk_widget_hide(window1);
}
/** It is called when student choose to back to the main page
 */
void button_Back()
{   
	gtk_widget_hide(window3);
}
/** Message dialog to give any feedback to the student's or admin's action
 */
void msg_dialog1()
{
   	GtkWidget *dialog;

   	dialog = gtk_message_dialog_new (NULL,
	GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
	   "Answers successfully submitted to our database");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
}
/** Message dialog to give any feedback to the student's or admin's action
 */
void msg_dialog2()
{
  	GtkWidget *dialog;

    	dialog = gtk_message_dialog_new (NULL,
	GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
	   "You are now successfully registered");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
}
/** Message dialog to give any feedback to the student's or admin's action
 */
void msg_dialog3()
{
   	GtkWidget *dialog;

    	dialog = gtk_message_dialog_new (NULL,
	GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
	   "You already submitted for this assignment and couldn't resubmit it!!");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
}
/** Message dialog to give any feedback to the student's or admin's action
 */
void msg_dialog4()
{
   	GtkWidget *dialog;

    	dialog = gtk_message_dialog_new (NULL,
	GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
	   "Question successfully submitted to database. Insert next question.");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
}
/** Message dialog to give any feedback to the student's or admin's action
 */
void msg_dialog5()
{
   	GtkWidget *dialog;

    	dialog = gtk_message_dialog_new (NULL,
	GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
	   "Question successfully updated to database.");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
}
/** Message dialog to give any feedback to the student's or admin's action
 */
void msg_dialog6()
{
   	GtkWidget *dialog;

    	dialog = gtk_message_dialog_new (NULL,
	GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
	   "You already registered to this system it!!");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
}
/** This function is called when the student choose to submit their answers to 
 * the database system and this function will connect to the database and inserting
 * student's answers to the table submission in the database.
 * @param widget Widget which generated the event
 * @param data any additional data passed while generating signal
 */
void add_records(GtkWidget *widget, gpointer data)
{
	GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));
  	GtkTextIter i1, it;
  	gchar *text,k;
	int i;


  	gtk_text_buffer_get_iter_at_mark(buffer, &it, gtk_text_buffer_get_insert(buffer));

  	k = gtk_text_iter_get_line(&it);
 	gtk_text_buffer_get_iter_at_line(buffer, &it, k);
 	gtk_text_buffer_get_end_iter(buffer, &i1);
 	text = gtk_text_buffer_get_text(buffer, &it, &i1, FALSE);

  	for( i=0;text[i];i++);
  		text[i]=0;
	
	const char *assgNo =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)name_entry));
	const char *email =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)username_entry));
	
    	char sql_statement[BUFFER];
   
    	int result2;
	connection1 = mysql_init(NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
	 	sprintf(sql_statement,"insert into submission (assgNo,email,answers)values('%s','%s','%s')",assgNo,email,text);
	
	 	result2 = mysql_query (connection1, sql_statement);
	
		if (result2==0)
		{
	    		printf ("Row inserted successfully.\n");
			msg_dialog1();
			
			
		}
		else
		{
	    		fprintf (stderr, "Could not insert data");
			msg_dialog3();
	    		
		}
		
		mysql_close (connection1);
   	 }
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
    	}
}
/** This function is called when the admin choose to submit their questions to 
 * the database system and this function will connect to the database and inserting
 * admin's questions to the table assignmnt in the database.
 * @param widget Widget which generated the event
 * @param data any additional data passed while generating signal
 */
void add_records1(GtkWidget *widget, gpointer data)
{
	GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(viewQuest));
  	GtkTextIter i1, it;
  	gchar *text,k;
	int i;


  	gtk_text_buffer_get_iter_at_mark(buffer, &it, gtk_text_buffer_get_insert(buffer));

  	k = gtk_text_iter_get_line(&it);
 	gtk_text_buffer_get_iter_at_line(buffer, &it, k);
 	gtk_text_buffer_get_end_iter(buffer, &i1);
 	text = gtk_text_buffer_get_text(buffer, &it, &i1, FALSE);

  	for( i=0;text[i]&& text[i]=='\n';i++);
  		text[i]=0;

	const char *assgNo =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)assig_no));
	const char *questNo =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)quest_no));
	
    	char sql_statement[BUFFER];
   
    	int result2;
	connection1 = mysql_init(NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
	 	sprintf(sql_statement,"insert into assignmnt (assigNo,qNo,listQuestions)values('%s','%s','%s')",assgNo,questNo,text);
	
	 	result2 = mysql_query (connection1, sql_statement);
	
		if (result2==0)
		{
	    		printf ("Row inserted successfully.\n");
			msg_dialog4();
			
			
		}
		else
		{
	    		fprintf (stderr, "Could not insert data");
			msg_dialog3();
	    		
		}
		
		mysql_close (connection1);
   	 }
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
    	}
}
/** This function is called when the student choose to view current assignment's questions 
 * from the database system and this function will connect to the database and select
 * qNo and listQuestions from the table submission in the database and display it to the student.
 * @param widget Widget which generated the event
 * 
 */
void fetch_records(GtkWidget *widget, GdkEventKey *event, GtkWidget *label1)
{
    	char sql_statement[BUFFER];
    	int return_value;
	const char *assgNo =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)name_entry));

    	connection1=mysql_init (NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
    		sprintf(sql_statement, "SELECT qNo, listQuestions from assignmnt where assigNo = '%s'",assgNo);
    		return_value = mysql_query (connection1, sql_statement);

   		if (return_value)
		{
	    		printf ("select failed as : %s\n", mysql_error (connection1));
		}
		else
		{
	    		result = mysql_use_result (connection1);
	    		if (result)
	    		{
				if (mysql_use_result (connection1)==0)
				{
			
					while ((sqlrow = mysql_fetch_row (result)))
		    				display_row ();
				}
				else
				{	
					printf("Data that you search not in the database");
			
				}
	    		}
	    		mysql_free_result(result);
		}
		mysql_close (connection1);
    	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
		exit(EXIT_FAILURE);
    	}
	
}
/** This function is called when the student choose to view current assignment's number 
 * from the database system that available in the system currently and this function will connect to the database.
 * and the system will select assigNo from the table assignmnt in the database and display it to the student.
 * @param widget Widget which generated the event
 * 
 */
void fetch_records1(GtkWidget *widget, GdkEventKey *event, GtkWidget *label1)
{
    	char sql_statement[BUFFER];
    	int return_value;

    	connection1=mysql_init (NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
		sprintf(sql_statement, "SELECT assigNo from assignmnt");
    		return_value = mysql_query (connection1, sql_statement);
   		if (return_value)
		{
	    		printf ("select failed as : %s\n", mysql_error (connection1));
		}
		else
		{
	    		result = mysql_use_result (connection1);
	    		if (result)
	    		{
				if (mysql_use_result (connection1)==0)
				{
			
					while ((sqlrow = mysql_fetch_row (result)))
		    				display_row1 ();
				}
				else
				{	
					printf("Data that you search not in the database");
			
				}
		
	    		}
	   		 mysql_free_result(result);
		}
		mysql_close (connection1);
   	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
		exit(EXIT_FAILURE);
   	}
	
}
/** This function is called when the student choose to view their previous answers 
 * from the database system and this function will connect to the database
 * and the system will select assigNo and answers from the table submission in the database 
 * and display it to the student.
 * @param widget Widget which generated the event
 */
void fetch_records2(GtkWidget *widget, GdkEventKey *event, GtkWidget *label1)
{
    	char sql_statement[BUFFER];
    	int return_value;
	const char *email =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)username_entry));

    	connection1=mysql_init (NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
    		sprintf(sql_statement, "SELECT assgNo,answers from submission where email = '%s'",email);
    		return_value = mysql_query (connection1, sql_statement);

   		if (return_value)
		{
	    		printf ("select failed as : %s\n", mysql_error (connection1));
		}
		else
		{
	    		result = mysql_use_result (connection1);
	    		if (result)
	    		{
				if (mysql_use_result (connection1)==0)
				{
			
					while ((sqlrow = mysql_fetch_row (result)))
		    				display_row2 ();
				}
				else
				{	
					printf("Data that you search not in the database");
			
				}
	    		}
	    		mysql_free_result(result);
		}
		mysql_close (connection1);
    	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
		exit(EXIT_FAILURE);
    	}
	
}
/** This function is called when the student choose to view current assignment's questions
 * from the database system that available in the system currently and this function will connect to the database.
 * and the system will select qNo and listQuestions from the table assignmnt in the database and display it to the student.
 * @param widget Widget which generated the event
 * 
 */
void fetch_records3(GtkWidget *widget, GdkEventKey *event, GtkWidget *label1)
{
    	char sql_statement[BUFFER];
    	int return_value;
	const char *assigNo =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)assig_no1));

    	connection1=mysql_init (NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
    		sprintf(sql_statement, "SELECT qNo, listQuestions from assignmnt where assigNo = '%s'",assigNo);
    		return_value = mysql_query (connection1, sql_statement);

   		if (return_value)
		{
	    		printf ("select failed as : %s\n", mysql_error (connection1));
		}
		else
		{
	    		result = mysql_use_result (connection1);
	    		if (result)
	    		{
				if (mysql_use_result (connection1)==0)
				{
			
					while ((sqlrow = mysql_fetch_row (result)))
		    				display_row4 ();
				}
				else
				{	
					printf("Data that you search not in the database");
			
				}
		
	    		}
	   		mysql_free_result(result);
		}
		mysql_close (connection1);
    	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
		exit(EXIT_FAILURE);
    	}
	
}
/** This function is called when admin choose to display the number of students that already  
 *  submitted their assignment to the system and this function will connect to the database
 * and the system will select student based on their email from the table submission in the database 
 * and display it to admin.
 * @param widget Widget which generated the event
 * 
 */
void fetch_records4(GtkWidget *widget, GdkEventKey *event, GtkWidget *label1)
{
    	char sql_statement[BUFFER];
    	int return_value;
	const char *assgNo =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)assig_no2));

    	connection1=mysql_init (NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
    		sprintf(sql_statement, "SELECT email from submission where assgNo = '%s'",assgNo);
    		return_value = mysql_query (connection1, sql_statement);

   		if (return_value)
		{
	    		printf ("select failed as : %s\n", mysql_error (connection1));
		}
		else
		{
	    		result = mysql_use_result (connection1);
	    		if (result)
	    		{
				if (mysql_use_result (connection1)==0)
				{
			
					while ((sqlrow = mysql_fetch_row (result)))
		    				display_row5 ();
				}
				else
				{	
					printf("Data that you search not in the database");
			
				}
	   		}
	    		mysql_free_result(result);
		}
		mysql_close (connection1);
    	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
		exit(EXIT_FAILURE);
    	}
	
}
/** This function is called when admin choose to display the number of students that already  
 *  submitted their assignment to the system and this function will connect to the database
 * and the system will select student based on their email from the table submissionFile in the database 
 * and display it to admin.
 * @param widget Widget which generated the event
 * 
 */
void fetch_records5(GtkWidget *widget, GdkEventKey *event, GtkWidget *label1)
{
    	char sql_statement[BUFFER];
    	int return_value;
	const char *assgNo =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)assig_no2));

    	connection1=mysql_init (NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
    		sprintf(sql_statement, "SELECT email from submissionFile where assgNo = '%s'",assgNo);
    		return_value = mysql_query (connection1, sql_statement);

   		if (return_value)
		{
	    		printf ("select failed as : %s\n", mysql_error (connection1));
		}
		else
		{
	    		result = mysql_use_result (connection1);
	    		if (result)
	    		{
				if (mysql_use_result (connection1)==0)
				{
			
					while ((sqlrow = mysql_fetch_row (result)))
		    				display_row5 ();
				}
				else
				{	
					printf("Data that you search not in the database");
			
				}
	   		}
	    		mysql_free_result(result);
		}
		mysql_close (connection1);
    	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
		exit(EXIT_FAILURE);
    	}
	
}
/** This function is called when the student choose to view their previous  file answers 
 * from the database system and this function will connect to the database
 * and the system will select assigNo and answers from the table submission in the database 
 * and display it to the student.
 * @param widget Widget which generated the event
 */
void fetch_records6(GtkWidget *widget, GdkEventKey *event, GtkWidget *label1)
{
    	char sql_statement[BUFFER];
    	int return_value;
	const char *email =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)username_entry));

    	connection1=mysql_init (NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
    		sprintf(sql_statement, "SELECT assgNo,filename from submissionFile where email = '%s'",email);
    		return_value = mysql_query (connection1, sql_statement);

   		if (return_value)
		{
	    		printf ("select failed as : %s\n", mysql_error (connection1));
		}
		else
		{
	    		result = mysql_use_result (connection1);
	    		if (result)
	    		{
				if (mysql_use_result (connection1)==0)
				{
			
					while ((sqlrow = mysql_fetch_row (result)))
		    				display_row2 ();
				}
				else
				{	
					printf("Data that you search not in the database");
			
				}
	    		}
	    		mysql_free_result(result);
		}
		mysql_close (connection1);
    	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
		exit(EXIT_FAILURE);
    	}
	
}
/** This function is called when admin choose to save the questions that they already edited  
 *  from the system and this function will connect to the database
 * and the system will modify the questions that currently in the database. 
 */
void modify_records()
{
	char sql_statement[BUFFER];
    	int return_value;
	GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(viewQuest1));
  	GtkTextIter i1, it;
  	gchar *text,k;
	int i;

  	gtk_text_buffer_get_iter_at_mark(buffer, &it, gtk_text_buffer_get_insert(buffer));

  	k = gtk_text_iter_get_line(&it);
 	gtk_text_buffer_get_iter_at_line(buffer, &it, k);
 	gtk_text_buffer_get_end_iter(buffer, &i1);
 	text = gtk_text_buffer_get_text(buffer, &it, &i1, FALSE);
  	
	for( i=0;text[i];i++);
  		text[i]=0;
	
	const char *assgNo =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)assig_no1));
	
    	connection1=mysql_init(NULL);
    	if(mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
		printf ("Connection success\n");

		sprintf(sql_statement, "update assignmnt set listQuestions='%s' where assigNo='%s'",text,assgNo);
		return_value = mysql_query(connection1,sql_statement);
		if (!return_value)
		{
	    		printf ("Updated %lu rows\n", (unsigned long) mysql_affected_rows (connection1));
			if (mysql_affected_rows (connection1)==0)
			{
				printf("No updated data");
			}
			else
			{
				printf("Successful updated data");
				msg_dialog5();
			}
		}
		else
		{
	   	 	fprintf (stderr, "Update failed as %d: %s\n", mysql_errno (connection1), mysql_error (connection1));
		}

		mysql_close (connection1);
    	}
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n", mysql_errno (connection1), mysql_error (connection1));
		}
    	}

}
/** This function is called from fetch_records function to display 
 *  the row data from the database
 */
void display_row ()
{
    	unsigned int field_count;

    	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(view1));
	
    	gtk_text_buffer_get_iter_at_offset(buffer, &iter, 0);
    
    	field_count = 0;
	
    	while (field_count < mysql_field_count (connection1))
    	{
	
		gtk_text_buffer_insert(buffer, &iter, sqlrow[field_count], -1);
		gtk_text_buffer_insert(buffer, &iter, "\t", -1);
	
		field_count++;
    	}
		gtk_text_buffer_insert(buffer, &iter, "\n", -1);
	
}
/** This function is called from fetch_records function to display 
 *  the row data from the database
 */
void display_row1 ()
{
    	unsigned int field_count;
	
    	char display_message[100];
	
    	field_count = 0;

    	while (field_count < mysql_field_count (connection1))
    	{
		sprintf(display_message, "%s ", sqlrow[field_count]);
		field_count++;
    	}
	
	gtk_entry_set_text(GTK_ENTRY(name_entry), display_message);
	
}
/** This function is called from fetch_records function to display 
 *  the row data from the database
 */
void display_row2 ()
{
    	unsigned int field_count;

    	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(viewQuest));
    
    	gtk_text_buffer_get_iter_at_offset(buffer, &iter, 0);
    
    	field_count = 0;
	
    	while (field_count < mysql_field_count (connection1))
    	{
		gtk_text_buffer_insert(buffer, &iter, sqlrow[field_count], -1);
		gtk_text_buffer_insert(buffer, &iter, "\t", -1);
		field_count++;
    	}
	gtk_text_buffer_insert(buffer, &iter, "\n", -1);
	
}
/** This function is called from fetch_records function to display 
 *  the row data from the database
 */
void display_row3 ()
{
    	unsigned int field_count;
	char display_message[100];
	
    	field_count = 0;

    	while (field_count < mysql_field_count (connection1))
    	{
		sprintf(display_message, "Welcome %s ", sqlrow[field_count]);
		field_count++;
    	}
    	
}
/** This function is called from fetch_records function to display 
 *  the row data from the database
 */
void display_row4 ()
{
    unsigned int field_count;

    buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(viewQuest1));
   
    gtk_text_buffer_get_iter_at_offset(buffer, &iter, 0);
    
    field_count = 0;
	
    while (field_count < mysql_field_count (connection1))
    {
	gtk_text_buffer_insert(buffer, &iter, sqlrow[field_count], -1);
	gtk_text_buffer_insert(buffer, &iter, "\t", -1);
	

	field_count++;
    }
	gtk_text_buffer_insert(buffer, &iter, "\n", -1);
	
}
/** This function is called from fetch_records function to display 
 *  the row data from the database
 */
void display_row5 ()
{
    	unsigned int field_count;

    	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(viewStudent));
    
    	gtk_text_buffer_get_iter_at_offset(buffer, &iter, 0);
    
    	field_count = 0;
	
    	while (field_count < mysql_field_count (connection1))
    	{
		gtk_text_buffer_insert(buffer, &iter, sqlrow[field_count], -1);
		gtk_text_buffer_insert(buffer, &iter, "\t", -1);

		field_count++;
    	}
	gtk_text_buffer_insert(buffer, &iter, "\n", -1);
	
}
/** This function is called to clear text from the entry field 
 *  and text view field.
 */
void clear()
{
	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(view2));
    	gtk_text_buffer_set_text (buffer, " ", -1);

	buffer1=gtk_text_view_get_buffer(GTK_TEXT_VIEW(view1));
    	gtk_text_buffer_set_text (buffer1, " ", -1);

	buffer2=gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));
    	gtk_text_buffer_set_text (buffer2, " ", -1);

	buffer3=gtk_text_view_get_buffer(GTK_TEXT_VIEW(viewQuest));
    	gtk_text_buffer_set_text (buffer3, " ", -1);

	gtk_entry_set_text(GTK_ENTRY(quest_no), " ");
}
/** This function is called to clear text from the entry field 
 *  and text view field.
 */
void clear1()
{
	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(viewQuest1));
    	gtk_text_buffer_set_text (buffer, " ", -1);

	gtk_entry_set_text(GTK_ENTRY(assig_no1), " ");
}
/** This function is called to clear text from the entry field 
 *  and text view field.
 */
void clear2()
{
	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(viewStudent));
    	gtk_text_buffer_set_text (buffer, " ", -1);

	gtk_entry_set_text(GTK_ENTRY(assig_no2), " ");
}
/** This function is called to set TRUE or FALSE editable
 *  on text view field.
 */
void editable()
{
	gtk_text_view_set_editable(GTK_TEXT_VIEW (view), TRUE);
}
/** This function is called to set TRUE or FALSE editable
 *  on text view field.
 */
void editable1()
{
	gtk_text_view_set_editable(GTK_TEXT_VIEW (view), FALSE);
}
/** This function is called to set TRUE or FALSE editable
 *  on text view field.
 */
void editable3()
{
	gtk_text_view_set_editable(GTK_TEXT_VIEW (viewQuest1), TRUE);
	
}
/** This function is called to display register_interface page
 * @param widget Widget which generated the event
 * @param data any additional data passed while generating signal
 */
void signup(GtkWidget *widget, gpointer data)
{		
	register_interface();
}
/** This function is called to display viewAnswers_interface page
 * @param widget Widget which generated the event
 * @param data any additional data passed while generating signal 
 */
void viewAnswer(GtkWidget *widget, gpointer data)
{		
	viewAnswers_interface();
}
/** This function is called when new student choose to register to the system
 * using register_interface and this function will connect to the database and 
 * inserting student's information to the register table
 * and store that information.
 * @param widget Widget which generated the event
 * @param data any additional data passed while generating signal
 */
void button_ok_register(GtkWidget *widget, gpointer data)
{
	char sql_statement[BUFFER];
	int result;

        const char *username =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)username_entry1));
        const char *password =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)password_entry1));
 	const char *email_text =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)email_entry1));
	const char *rollNo_text =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)rollNo_entry1));
	
	connection1 = mysql_init(NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
        	sprintf(sql_statement,"insert into register (name,rollNo,password,email)values('%s','%s','%s','%s')",username,rollNo_text,password,email_text);
		result = mysql_query (connection1, sql_statement);

		if (result==0)
		{
			printf ("Row inserted successfully.\n");
			msg_dialog2();
		}
		else
		{
			fprintf (stderr, "Could not insert data as %d: %s\n",
			mysql_errno (connection1),
		     	mysql_error (connection1));
			msg_dialog6();
		     	
		}
		mysql_close (connection1);
   	 }
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
    	}
}
/** It is called when user click button cancel in the register interface 
 * and will allow the student to go back to the login interface
 * @param widget Widget which generated the event
 * @param data any additional data passed while generating signal
 */
void button_cancel_register(GtkWidget *widget, gpointer data)
{
	gtk_widget_hide(window2);
}
/** Message dialog to give any feedback to the student's or admin's action
 */
void msg_dialog()
{
   	GtkWidget *dialog;

    	dialog = gtk_message_dialog_new (NULL,
	GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
	   "Answers successfully saved to the external file");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);

}
/** It is called when user click button save in the assignment interface 
 * and will save all the student's answers to the external file in the hardisk
 * before they submit their final answers to the database.
 */
void save()
{
    	FILE *sample_file;
    	char filename[100]="students_answers.txt";

    	GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));
  	GtkTextIter i1, it;
  	gchar *text,k;
	int i;

    	sample_file=fopen(filename, "w");
    	if(sample_file==NULL)
    	{
		fprintf(stderr, "Cant open file '%s' for writing\n", filename);
		perror("");
		exit(EXIT_FAILURE);
    	}

	gtk_text_buffer_get_iter_at_mark(buffer, &it, gtk_text_buffer_get_insert(buffer));

  	k = gtk_text_iter_get_line(&it);
 	gtk_text_buffer_get_iter_at_line(buffer, &it, k);
 	gtk_text_buffer_get_end_iter(buffer, &i1);
 	text = gtk_text_buffer_get_text(buffer, &it, &i1, FALSE);
  	
	for( i=0;text[i] && text[i]!='\n';i++);
  		text[i]=0;

    	fprintf(sample_file, "%s", text);
	msg_dialog();
}
/** It is called when user click button browse in the assignment interface 
 * and student can browse a file that contain the answer for the assignment
 * before upload the file path to the database.
 */
void browse()
{
	GtkWidget *dialog;
	char *filename;
	parent_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	dialog = gtk_file_chooser_dialog_new ("Browse File",
				      parent_window,
				      GTK_FILE_CHOOSER_ACTION_OPEN,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
  	{
    		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		gtk_entry_set_text(GTK_ENTRY(name_entry1), filename);
    		g_free (filename);
  	}
	gtk_widget_destroy (dialog);
	
}
/** It is called when user click button upload in the assignment interface 
 * and student will upload the file path to the database 
 * and system will inserting the file path into table submissionFile.
 */
void upload()
{
	const char *assgNo =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)name_entry));
	const char *name =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)username_entry));
	const char *filename =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)name_entry1));
	
    	char sql_statement[BUFFER];
   
    	int result2;
	connection1 = mysql_init(NULL);
    	if (mysql_real_connect (connection1, "localhost", "cs3002_user", "cs3002_password", "cs3002_database", 0, NULL, 0))
    	{
	
	 	sprintf(sql_statement,"insert into submissionFile (assgNo,email,filename)values('%s','%s','%s')",assgNo,name,filename);
	
	 	result2 = mysql_query (connection1, sql_statement);
	
		if (result2==0)
		{
	    		printf ("Row inserted successfully.\n");
			msg_dialog1();
			
			
		}
		else
		{
	    		fprintf (stderr, "Could not insert data");
			msg_dialog3();
	    		
		}
		
		mysql_close (connection1);
   	 }
    	else
    	{
		fprintf (stderr, "Connection failed\n");
		if (mysql_errno (connection1))
		{
	    		fprintf (stderr, "Connection error %d: %s\n",
		     	mysql_errno (connection1),
		     	mysql_error (connection1));
		}
    	}
}
/** This is a function to create help interface which allow student to view the information
 * about the system, so that it easy for the beginner to understand this system.
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 */
void help_interface(int argc, char *argv[])
{
 	GtkWidget *box_A;
	GtkWidget *label_help;
	GtkWidget *label_hi;
	GtkWidget *buttonClose;
	GtkWidget *fixed;

	gtk_init (&argc, &argv);

  	window3 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  
  	gtk_window_set_title (GTK_WINDOW (window3), "Aspect Frame");
  
  	g_signal_connect (G_OBJECT (window3), "destroy",G_CALLBACK (exit), NULL);
  
  	gtk_window_set_title (GTK_WINDOW (window3), "Software Technology Assignment Submission System");
  	gtk_container_set_border_width (GTK_CONTAINER (window3), 10);
  	gtk_window_set_default_size(GTK_WINDOW(window1),600,1000);

  	box_A = gtk_vbox_new (FALSE, 2);
  	gtk_container_set_border_width (GTK_CONTAINER (box_A), 2);
  	gtk_container_add (GTK_CONTAINER (window3), box_A);
  	gtk_widget_show (box_A);

        fixed = gtk_fixed_new();
        gtk_box_pack_start (GTK_BOX (box_A), fixed, FALSE, FALSE, 0);

	label_help = gtk_label_new ("How to use this system:");
	gtk_fixed_put(GTK_FIXED(fixed), label_help , 2, 2);
        gtk_widget_set_size_request(label_help , 200, 30);


	label_help = gtk_label_new ("**You can view current assignment number and the questions \nrelated to this assignment by click the 'Current assignment' \nbutton and 'View current questions for this assignment' button.\nYou can type your answers on the text view that have \nbeen provided to you in this page and you can submit your answers to the \ndatabase by clicking the 'Submit' button and you also can save your \nanswers to the external file as backup answer\n(in case if your answers fail to be submitted to the database) \nby clicking the 'Save' button. You also can upload any files if \nneeded by clicking the 'Browse' and 'Upload' button. \nFor the same assignment, \nyou can submit your answers once only, which means a student \ncannot submitted the assignment more than once. \nYou are allow to view your previous assignment's answers \nby clicking the 'Previous answer' button. If you want to logout \nfrom the system choose the 'Logout' button.**");
	gtk_fixed_put(GTK_FIXED(fixed), label_help , 10, 10);
        gtk_widget_set_size_request(label_help , 500, 300);

	buttonClose = gtk_button_new_with_label("Close");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonClose, 50, 300);
  	gtk_widget_set_size_request(buttonClose, 250, 30);

	g_signal_connect(G_OBJECT(buttonClose), "clicked", G_CALLBACK(button_Back),NULL);

	gtk_widget_show_all(fixed);  

	gtk_widget_show (window3);
	
	gtk_main();
}
/** This is a function to create view answer interface which allow student to view their previous answers
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 */
void viewAnswers_interface(int argc, char *argv[])
{
	GtkWidget *box_A;
	GtkWidget *buttonView;
	GtkWidget *buttonBack;
	GtkWidget *fixed;

	gtk_init (&argc, &argv);

  	window3 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  
  	gtk_window_set_title (GTK_WINDOW (window3), "Aspect Frame");
  
  	g_signal_connect (G_OBJECT (window3), "destroy",G_CALLBACK (exit), NULL);
  
  	gtk_window_set_title (GTK_WINDOW (window3), "Software Technology Assignment Submission System");
  	gtk_container_set_border_width (GTK_CONTAINER (window3), 10);
  	gtk_window_set_default_size(GTK_WINDOW(window1),400,400);

  	box_A = gtk_vbox_new (FALSE, 5);
  	gtk_container_set_border_width (GTK_CONTAINER (box_A), 5);
  	gtk_container_add (GTK_CONTAINER (window3), box_A);
  	gtk_widget_show (box_A);

        fixed = gtk_fixed_new();
        gtk_box_pack_start (GTK_BOX (box_A), fixed, FALSE, FALSE, 0);

	buttonView = gtk_button_new_with_label("View your answers");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonView, 50, 30);
  	gtk_widget_set_size_request(buttonView, 250, 30);

	viewQuest = gtk_text_view_new();
  	gtk_fixed_put(GTK_FIXED(fixed), viewQuest , 10, 100);
  	gtk_text_view_set_editable(GTK_TEXT_VIEW (viewQuest ), TRUE);
        gtk_widget_set_size_request(  viewQuest , 400, 160);

	buttonBack = gtk_button_new_with_label("Back to Main Page");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonBack, 50, 300);
  	gtk_widget_set_size_request(buttonBack, 250, 30);

	g_signal_connect(G_OBJECT(buttonView), "clicked", G_CALLBACK(fetch_records2),NULL);
	g_signal_connect(G_OBJECT(buttonView), "clicked", G_CALLBACK(fetch_records6),NULL);
	g_signal_connect(G_OBJECT(buttonBack), "clicked", G_CALLBACK(button_Back),NULL);

	gtk_widget_show_all(fixed);  

	gtk_widget_show (window3);
	
	gtk_main();
}
/** This is a function to create admin interface which allow 
 * admin to create questions, view and edit the assignment's questions
 * and display list of students that submitted the assignment.
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 */
void admin_interface(int argc, char *argv[])
{
	GtkWidget *box_A;
  	GtkWidget *label_A;
	GtkWidget *label_A1;
	GtkWidget *label_B;
	GtkWidget *label_create;
	GtkWidget *label_list;
        GtkWidget *fixed;
  	GtkWidget *label_C;
	GtkWidget *label_edit;
  	GtkWidget *buttonDisplay;
	GtkWidget *buttonLogout;
	GtkWidget *buttonHistory1;
	GtkWidget *buttonSubmit;
	GtkWidget *buttonSave1;
	GtkWidget *buttonEdit;
	GtkWidget *buttonClear;
	GtkWidget *buttonClear1;
   
  	gtk_init (&argc, &argv);

  	window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  
  	gtk_window_set_title (GTK_WINDOW (window1), "Aspect Frame");
  
  	g_signal_connect (G_OBJECT (window1), "destroy",G_CALLBACK (exit), NULL);
  
  	gtk_window_set_title (GTK_WINDOW (window1), "Software Technology Assignment Submission System");
  	gtk_container_set_border_width (GTK_CONTAINER (window1), 10);
  	gtk_window_set_default_size(GTK_WINDOW(window1),700,200);

  	box_A = gtk_vbox_new (FALSE, 5);
  	gtk_container_set_border_width (GTK_CONTAINER (box_A), 5);
  	gtk_container_add (GTK_CONTAINER (window1), box_A);
  	gtk_widget_show (box_A);

	label_D = gtk_label_new ("WELCOME TO ADMIN PAGE");
        gtk_box_pack_start (GTK_BOX (box_A),  label_D, FALSE, TRUE, 0);
  	gtk_widget_grab_focus(label_D);
  	gtk_widget_show (label_D);


        fixed = gtk_fixed_new();
        gtk_box_pack_start (GTK_BOX (box_A), fixed, FALSE, FALSE, 0);

        buttonHistory1 = gtk_button_new_with_label("View assignments and questions");
        gtk_fixed_put(GTK_FIXED( fixed), buttonHistory1, 600, 95);
 	gtk_widget_set_size_request(buttonHistory1, 250, 30);
	
  	buttonDisplay = gtk_button_new_with_label("Display List of Students");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonDisplay, 450, 390);
  	gtk_widget_set_size_request(buttonDisplay, 200, 30);

	buttonClear1 = gtk_button_new_with_label("Clear");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonClear1, 470, 430);
  	gtk_widget_set_size_request(buttonClear1, 80, 35);

	buttonLogout = gtk_button_new_with_label("Logout");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonLogout, 730, 2);
  	gtk_widget_set_size_request(buttonLogout, 80, 30);

	label_create = gtk_label_new ("Create assignment and question here :");
    	gtk_fixed_put(GTK_FIXED(fixed), label_create, 2, 100); 

	label_A = gtk_label_new ("Assignment No :");
    	gtk_fixed_put(GTK_FIXED(fixed), label_A, 2, 130);

	assig_no= gtk_entry_new_with_max_length (100);
  	gtk_fixed_put(GTK_FIXED(fixed), assig_no, 120, 125);
	gtk_entry_set_editable(GTK_ENTRY (assig_no), TRUE);
	gtk_widget_set_size_request(assig_no, 25, 30);

	label_B = gtk_label_new ("Question No :");
    	gtk_fixed_put(GTK_FIXED(fixed), label_B, 2, 160);

	quest_no=gtk_entry_new_with_max_length (100);
  	gtk_fixed_put(GTK_FIXED(fixed), quest_no, 120, 160);
	gtk_entry_set_editable(GTK_ENTRY (quest_no), TRUE);
	gtk_widget_set_size_request(quest_no, 25, 30);
	
	viewQuest = gtk_text_view_new();
  	gtk_fixed_put(GTK_FIXED(fixed), viewQuest , 2, 200);
  	gtk_text_view_set_editable(GTK_TEXT_VIEW (viewQuest ), TRUE);
        gtk_widget_set_size_request(  viewQuest , 300, 100);

	label_edit = gtk_label_new ("View and edit questions here :");
    	gtk_fixed_put(GTK_FIXED(fixed), label_edit, 450, 70);

	label_A1 = gtk_label_new ("Assignment No :");
    	gtk_fixed_put(GTK_FIXED(fixed), label_A1, 450, 100);

	assig_no1= gtk_entry_new_with_max_length (100);
  	gtk_fixed_put(GTK_FIXED(fixed), assig_no1, 560, 95);
	gtk_entry_set_editable(GTK_ENTRY (assig_no1), TRUE);
	gtk_widget_set_size_request(assig_no1, 25, 30);

	label_list = gtk_label_new ("List of questions :");
    	gtk_fixed_put(GTK_FIXED(fixed), label_list, 450, 130); 

	viewQuest1 = gtk_text_view_new();
  	gtk_fixed_put(GTK_FIXED(fixed), viewQuest1 , 450, 150);
  	gtk_text_view_set_editable(GTK_TEXT_VIEW (viewQuest1 ), FALSE);
        gtk_widget_set_size_request(  viewQuest1 , 450, 150);

	buttonSubmit = gtk_button_new_with_label("Submit");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonSubmit, 10, 320);
  	gtk_widget_set_size_request(buttonSubmit, 80, 35);

	buttonEdit = gtk_button_new_with_label("Edit");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonEdit, 450, 320);
  	gtk_widget_set_size_request(buttonEdit, 80, 35);

	buttonSave1 = gtk_button_new_with_label("Save");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonSave1, 540, 320);
  	gtk_widget_set_size_request(buttonSave1, 80, 35);

	buttonClear = gtk_button_new_with_label("Clear");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonClear, 630, 320);
  	gtk_widget_set_size_request(buttonClear, 80, 35);
  
	label_C = gtk_label_new ("List of Students that have submitted the assignment number:");
    	gtk_fixed_put(GTK_FIXED(fixed), label_C, 2, 400); 

	assig_no2= gtk_entry_new_with_max_length (100);
  	gtk_fixed_put(GTK_FIXED(fixed), assig_no2, 410, 390);
	gtk_entry_set_editable(GTK_ENTRY (assig_no2), TRUE);
	gtk_widget_set_size_request(assig_no2, 25, 30);
        
	viewStudent = gtk_text_view_new();
  	gtk_fixed_put(GTK_FIXED(fixed), viewStudent, 2, 420);
  	gtk_text_view_set_editable(GTK_TEXT_VIEW (viewStudent ), FALSE);
        gtk_widget_set_size_request(  viewStudent , 450, 200);
    	
        gtk_widget_show_all(fixed);  

	g_signal_connect(G_OBJECT(buttonHistory1), "clicked", G_CALLBACK(fetch_records3),NULL);

	g_signal_connect(G_OBJECT(buttonDisplay), "clicked", G_CALLBACK(fetch_records4),NULL);
	g_signal_connect(G_OBJECT(buttonDisplay), "clicked", G_CALLBACK(fetch_records5),NULL);

	g_signal_connect(G_OBJECT(buttonSubmit), "clicked", G_CALLBACK(add_records1),NULL);
	g_signal_connect(G_OBJECT(buttonSubmit), "clicked", G_CALLBACK(clear),NULL);

	g_signal_connect(G_OBJECT(buttonSave1), "clicked", G_CALLBACK(modify_records),NULL);
	g_signal_connect(G_OBJECT(buttonEdit), "clicked", G_CALLBACK(editable3),NULL);

	g_signal_connect(G_OBJECT(buttonClear), "clicked", G_CALLBACK(clear1),NULL);
	g_signal_connect(G_OBJECT(buttonClear1), "clicked", G_CALLBACK(clear2),NULL);

	g_signal_connect(G_OBJECT(buttonLogout), "clicked", button_Logout, NULL);

  	gtk_widget_show (window1);
	
	gtk_main();

   return EXIT_SUCCESS;

}
/** This is a function to create assignment interface which allow 
 * student to view questions, type answers, save to the external file, 
 * and submit it to the database system.
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 */
void assignment_interface(int argc, char *argv[])
{
  	
 	GtkWidget *box_A;
  	GtkWidget *box_B;
	GtkWidget *box_C;
  	GtkWidget *label_A;
 	GtkWidget *separator;
        GtkWidget *fixed;
  	GtkWidget *label_C;
  	GtkWidget *buttonView;
	GtkWidget *buttonView1;
  	GtkWidget *buttonHelp;
	GtkWidget *buttonLogout;
	GtkWidget *fixed_A;
	GtkWidget *buttonHistory;
	GtkWidget *label_D;
	GtkWidget *buttonSubmit;
	GtkWidget *buttonSave;
	GtkWidget *buttonBrowse;
	GtkWidget *buttonUpload;
	
  	gtk_init (&argc, &argv);

  	window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  
  	gtk_window_set_title (GTK_WINDOW (window1), "Aspect Frame");
  
  	g_signal_connect (G_OBJECT (window1), "destroy",G_CALLBACK (exit), NULL);
  
  	gtk_window_set_title (GTK_WINDOW (window1), "Software Technology Assignment Submission System");
  	gtk_container_set_border_width (GTK_CONTAINER (window1), 10);
  	gtk_window_set_default_size(GTK_WINDOW(window1),3000,200);

  	box_A = gtk_vbox_new (FALSE, 5);
  	gtk_container_set_border_width (GTK_CONTAINER (box_A), 5);
  	gtk_container_add (GTK_CONTAINER (window1), box_A);
  	gtk_widget_show (box_A);

	label_D = gtk_label_new ("WELCOME");
        gtk_box_pack_start (GTK_BOX (box_A),  label_D, FALSE, TRUE, 0);
  	gtk_widget_grab_focus(label_D);
  	gtk_widget_show (label_D);

        fixed = gtk_fixed_new();
        gtk_box_pack_start (GTK_BOX (box_A), fixed, FALSE, FALSE, 0);

	buttonView = gtk_button_new_with_label("Current assignment");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonView, 2, 50);
  	gtk_widget_set_size_request(buttonView, 200, 30);

        buttonHistory = gtk_button_new_with_label("Previous answers");
        gtk_fixed_put(GTK_FIXED( fixed), buttonHistory, 300, 50);
 	gtk_widget_set_size_request(buttonHistory, 250, 30);
	
  	buttonHelp = gtk_button_new_with_label("Help");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonHelp, 630, 50);
  	gtk_widget_set_size_request(buttonHelp, 60, 30);

	buttonLogout = gtk_button_new_with_label("Logout");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonLogout, 750, 50);
  	gtk_widget_set_size_request(buttonLogout, 80, 30);

	label_A = gtk_label_new ("Assignment No :");
    	gtk_fixed_put(GTK_FIXED(fixed), label_A, 2, 100);

	name_entry= gtk_entry_new_with_max_length (100);
  	gtk_fixed_put(GTK_FIXED(fixed), name_entry, 120, 95);
	gtk_entry_set_editable(GTK_ENTRY (name_entry), TRUE);
	gtk_widget_set_size_request(name_entry, 30, 30);

	buttonView1 = gtk_button_new_with_label("View current questions for this assignment");
  	gtk_fixed_put(GTK_FIXED(fixed), buttonView1, 2, 140);
  	gtk_widget_set_size_request(buttonView1, 320, 30);

        gtk_widget_show_all(fixed);  

    	label_A = gtk_label_new ("Answer all the questions below :");
    	gtk_box_pack_start (GTK_BOX (box_A), label_A, FALSE, FALSE, 0);
    	gtk_widget_grab_focus(label_A);
    	gtk_widget_show (label_A);

	view1 = gtk_text_view_new();
  	gtk_box_pack_start(GTK_BOX(box_A), view1, FALSE, FALSE, 0);
  	gtk_text_view_set_editable(GTK_TEXT_VIEW (view1), FALSE);
        gtk_widget_set_size_request(  view1, 300, 150);
    	GTK_WIDGET_SET_FLAGS ( view1, GTK_CAN_DEFAULT);
    	gtk_widget_grab_focus( view1);
    	gtk_widget_show ( view1);
	
    	box_B = gtk_vbox_new (FALSE, 5);
    	gtk_container_set_border_width (GTK_CONTAINER (box_B), 5);
    	gtk_box_pack_start (GTK_BOX (box_A), box_B, FALSE, TRUE, 0);
    	gtk_widget_show (box_B);
  
        separator = gtk_hseparator_new ();
    	gtk_box_pack_start (GTK_BOX (box_A), separator, FALSE, TRUE, 0);
    	gtk_widget_show (separator);

	separator = gtk_hseparator_new ();
        gtk_box_pack_start (GTK_BOX (box_B), separator, FALSE, TRUE, 0);
        gtk_widget_show (separator);

 	label_C = gtk_label_new ("Answer here :");
    	gtk_box_pack_start (GTK_BOX (box_B), label_C, FALSE, FALSE, 0);
    	gtk_widget_grab_focus(label_C);
    	gtk_widget_show (label_C);
        
	view = gtk_text_view_new();
  	gtk_box_pack_start(GTK_BOX(box_B), view, FALSE, FALSE, 0);
  	gtk_text_view_set_editable(GTK_TEXT_VIEW (view), TRUE);
        gtk_widget_set_size_request(  view, 300, 170);
    	GTK_WIDGET_SET_FLAGS ( view, GTK_CAN_DEFAULT);
    	gtk_widget_grab_focus( view);
    	gtk_widget_show ( view);

	box_C = gtk_vbox_new (FALSE, 5);
    	gtk_container_set_border_width (GTK_CONTAINER (box_C), 5);
    	gtk_box_pack_start (GTK_BOX (box_B), box_C, FALSE, TRUE, 0);
    	gtk_widget_show (box_C);

	fixed_A = gtk_fixed_new();
        gtk_box_pack_start (GTK_BOX (box_C),  fixed_A, FALSE, FALSE, 0);

	buttonSave = gtk_button_new_with_label("Save");
  	gtk_fixed_put(GTK_FIXED(fixed_A), buttonSave, 300, 30);
  	gtk_widget_set_size_request(buttonSave, 60, 35);

	buttonSubmit = gtk_button_new_with_label("Submit");
  	gtk_fixed_put(GTK_FIXED(fixed_A), buttonSubmit, 400, 30);
  	gtk_widget_set_size_request(buttonSubmit, 80, 35);
	gtk_widget_show_all (fixed_A);

	name_entry1 = gtk_entry_new_with_max_length (100);
  	gtk_fixed_put(GTK_FIXED(fixed_A), name_entry1, 500, 30);
	gtk_entry_set_editable(GTK_ENTRY (name_entry1), TRUE);
	gtk_widget_set_size_request(name_entry1, 200, 35);

	buttonBrowse = gtk_button_new_with_label("Browse File");
  	gtk_fixed_put(GTK_FIXED(fixed_A), buttonBrowse, 700, 30);
  	gtk_widget_set_size_request(buttonBrowse, 100, 35);
	gtk_widget_show_all (fixed_A);

	buttonUpload = gtk_button_new_with_label("Upload File");
  	gtk_fixed_put(GTK_FIXED(fixed_A), buttonUpload, 800, 30);
  	gtk_widget_set_size_request(buttonUpload, 100, 35);
	gtk_widget_show_all (fixed_A);

	g_signal_connect(G_OBJECT(buttonView), "clicked", G_CALLBACK(clear),NULL);

	g_signal_connect(G_OBJECT(buttonView1), "clicked", G_CALLBACK(fetch_records),NULL);
	g_signal_connect(G_OBJECT(buttonView), "clicked", G_CALLBACK(fetch_records1),NULL);

	g_signal_connect(G_OBJECT(buttonView), "clicked", G_CALLBACK(editable),NULL);

	g_signal_connect(G_OBJECT(buttonHistory), "clicked", G_CALLBACK(viewAnswer),NULL);

	g_signal_connect(G_OBJECT(buttonSubmit), "clicked", G_CALLBACK(add_records),NULL);

	g_signal_connect(G_OBJECT(buttonSubmit), "clicked", G_CALLBACK(editable1),NULL);

	g_signal_connect(G_OBJECT(buttonSave), "clicked", G_CALLBACK(save),NULL);

	g_signal_connect(G_OBJECT(buttonBrowse), "clicked", G_CALLBACK(browse),NULL);
	g_signal_connect(G_OBJECT(buttonUpload), "clicked", G_CALLBACK(upload),NULL);

	g_signal_connect(G_OBJECT(buttonHelp), "clicked", help_interface, NULL);

	g_signal_connect(G_OBJECT(buttonLogout), "clicked", button_Logout, NULL);

  	gtk_widget_show (window1);
	
	gtk_main();

   return EXIT_SUCCESS;
}
/** This is a function to create register interface which allow 
 * admin and new student to register to the system
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 */
void register_interface(int argc, char *argv[])
{
	GtkWidget *fixed;
	GtkWidget *username;
	GtkWidget *password;
	GtkWidget *email;
	GtkWidget *rollNo;
	GtkWidget *label1;
	GtkWidget *buttonOk;
	GtkWidget *buttonCancelRegister;

	gtk_init(&argc, &argv);

	window2 = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window2), "Register");
	gtk_window_set_default_size(GTK_WINDOW(window2),400, 400);
	gtk_window_set_position(GTK_WINDOW(window2), GTK_WIN_POS_CENTER);

	fixed = gtk_fixed_new();
	gtk_container_add(GTK_CONTAINER(window2), fixed);

	label1 = gtk_label_new("*Registration for new students*");
	gtk_fixed_put(GTK_FIXED(fixed), label1, 30, 40);

	password_entry1 = gtk_entry_new_with_max_length (NULL);
	gtk_fixed_put(GTK_FIXED(fixed), password_entry1, 170, 200);
	gtk_entry_set_visibility(GTK_ENTRY (password_entry1), FALSE);

	username_entry1 = gtk_entry_new_with_max_length (NULL);
	gtk_fixed_put(GTK_FIXED(fixed), username_entry1, 170, 100);

	rollNo_entry1 = gtk_entry_new_with_max_length (NULL);
	gtk_fixed_put(GTK_FIXED(fixed), rollNo_entry1, 170, 150);
  
	password = gtk_label_new("Password");
	gtk_fixed_put(GTK_FIXED(fixed), password, 50, 200);
	gtk_widget_set_size_request(password, 80, 35);

	username = gtk_label_new("Name");
	gtk_fixed_put(GTK_FIXED(fixed), username, 50, 100);
	gtk_widget_set_size_request(username, 80, 35);
	
	rollNo = gtk_label_new("Roll No");
	gtk_fixed_put(GTK_FIXED(fixed), rollNo, 50, 150);
	gtk_widget_set_size_request(rollNo, 80, 35);

	email = gtk_label_new("Student Email ID");
	gtk_fixed_put(GTK_FIXED(fixed), email, 60, 250);
	gtk_widget_set_size_request(password, 80, 35);

	email_entry1 = gtk_entry_new_with_max_length (NULL);
	gtk_fixed_put(GTK_FIXED(fixed), email_entry1, 170, 250);

	buttonOk = gtk_button_new_with_label("Sign Up");
	gtk_fixed_put(GTK_FIXED(fixed), buttonOk, 100, 300);
	gtk_widget_set_size_request(buttonOk, 80, 35);

	buttonCancelRegister = gtk_button_new_with_label("Back to Login Page");
	gtk_fixed_put(GTK_FIXED(fixed), buttonCancelRegister, 200, 300);
	gtk_widget_set_size_request(buttonCancelRegister, 140, 35);

	g_signal_connect(G_OBJECT(buttonOk), "clicked", button_ok_register, NULL);
	g_signal_connect(G_OBJECT(buttonCancelRegister), "clicked", button_cancel_register, NULL);

	g_signal_connect_swapped(G_OBJECT(window2), "destroy", G_CALLBACK(gtk_main_quit), NULL);

	gtk_widget_show_all(window2);

    	gtk_main ();	
}

/**Main page for login interface
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 */
int main( int argc, char *argv[])
{
	GtkWidget *window;
	GtkWidget *fixed;
	GtkWidget *username;
	GtkWidget *password;
	GtkWidget *buttonsignup;
	GtkWidget *buttonOk;
	GtkWidget *buttonCancel;
	GtkWidget *label;
	GtkWidget *label1;

  	gtk_init(&argc, &argv);

  	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  	gtk_window_set_title(GTK_WINDOW(window), "Login");
	gtk_window_set_default_size(GTK_WINDOW(window),400, 400);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);

	fixed = gtk_fixed_new();
	gtk_container_add(GTK_CONTAINER(window), fixed);

	password_entry = gtk_entry_new_with_max_length (NULL);
	gtk_fixed_put(GTK_FIXED(fixed), password_entry, 170, 150);
	gtk_entry_set_visibility(GTK_ENTRY (password_entry), FALSE);
 	
	username_entry = gtk_entry_new_with_max_length (NULL);
	gtk_fixed_put(GTK_FIXED(fixed), username_entry, 170, 100);

	label = gtk_label_new("Welcome to ");
	gtk_fixed_put(GTK_FIXED(fixed), label, 150, 20);
	
	label1 = gtk_label_new("Software Technology Assignment Submission System");
	gtk_fixed_put(GTK_FIXED(fixed), label1, 30, 40);

	password = gtk_label_new("Password*");
	gtk_fixed_put(GTK_FIXED(fixed), password, 50, 150);
	gtk_widget_set_size_request(password, 80, 35);

	username = gtk_label_new("Email*");
	gtk_fixed_put(GTK_FIXED(fixed), username, 40, 100);
	gtk_widget_set_size_request(username, 80, 35);

	buttonOk = gtk_button_new_with_label("Ok");
	gtk_fixed_put(GTK_FIXED(fixed), buttonOk, 150, 200);
	gtk_widget_set_size_request(buttonOk, 80, 35);

	buttonCancel = gtk_button_new_with_label("Cancel");
	gtk_fixed_put(GTK_FIXED(fixed), buttonCancel, 250, 200);
	gtk_widget_set_size_request(buttonCancel, 80, 35);

	buttonsignup = gtk_button_new_with_label("Sign Up For New Student");
	gtk_fixed_put(GTK_FIXED(fixed), buttonsignup, 50, 300);

    	g_signal_connect(G_OBJECT(buttonOk), "clicked", button_ok_login,label_D);

	g_signal_connect(G_OBJECT(buttonCancel), "clicked", button_Cancel, NULL);
	g_signal_connect(G_OBJECT(buttonsignup), "clicked", signup, NULL);

  	gtk_widget_show_all(window);

  	gtk_main();

	return EXIT_SUCCESS;
}


