/**This project is to combine some of topic that learned in ITWS courses by created a standard ATM Machine application.
   Areas for project are:
	1) GUI programming (GTK) for interface
    	2) Server based databases (MySQL) for query statement to database
        3) Socket Programming for connection ATM machine with SHB bank which is SHB as server and ATM as client
        4) File Handling for create report file to write record transaction from database.
        5) Shell Command for send report by email to user as their references
   
   This ATM Machine is provide a separate GtkButtons for digits 0 to 9,Enter button to allow user go the next step in any transaction,
   Cancel button to allow user stop any transaction, Clear button to reset entry text and clear any value shown.Exit button to out of system.
   Also has some of buttons to allow user make transactions such as Balance button to allow user check their balance available currently,
   Withdrawal button to user make withdrawal money, Deposit button to allow user to add money in their account using machine,
   Transfer button to allow user transfer money into other account and Change Password button to allow user to change new password.
   There also be two GtkEntry which is first entry allow user to clicking on GtkButtons to enter the pin number, amount and no account.
   The second GtkEntry is to display instruction and message to user. This GtkEntry is set as false editable (user can't write).
   The ATM is provide GtkLabel to display name of bank, user name and account no.
  
   These ATM application is allow user to make one transaction in the one time such as withdrawal, deposit, transfer money,
   change password and balance. After user done one transaction such as withdrawal, record transaction will be saved in database.
   At the same time, one file will be generated to write that record transaction from database. This report file will be sent to
   mail user and SBH Bank with attached this file. The ATM should support normal floating point and integer calculations that can
   be done in C using float or integer data types.
   
  * @Project Title: ATM Machine application with sending report into email
  * @Author: Nooraini Bt Hamidon
  * @Roll No: 200905027
  * @Program : M.Tech CSE
  * @File: atmCOMPLETE.c
  *
  */



//define all library used in project

#define GTK_ENABLE_BROKEN 
#define BUFFER 4096

#include <gtk/gtk.h>
#include <glib.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "01-connect.h"
#include <mysql/mysql.h>

#include<sys/types.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<arpa/inet.h>

#define SERV_TCP_PORT 9999
#define BUFSIZE 1024

// declare database variable and pointer
MYSQL *connection1;
MYSQL_RES *result1;
MYSQL_ROW sqlrow;

// declare all function used in project to make all transaction 
static void send_mail();
static void create_report();
static void updated_password_record();
static void updated_transfer_account();
static void transfer_money ();
static void insert_report();
static void updated_record();
static void display_row1 ();
static void count_withdrawal ();
static void count_deposit ();
static void enter_callback( GtkWidget *entry, GdkEventKey *event, gpointer data );
static gboolean close_application( GtkWidget *widget,GdkEvent  *event);
static gboolean get_focus_click (GtkButton *button, gpointer data);
static gboolean enter_function (GtkButton *button_Enter, gpointer data);
static gboolean balance_function (GtkButton *button_Balance, gpointer data);
static gboolean withdraw_function (GtkButton *button_Withdraw, gpointer entry1);
static gboolean deposit_function (GtkButton *button_Deposit, gpointer entry1);
static gboolean transfer_function (GtkButton *button_Transfer, gpointer entry1);
static gboolean changePass_function (GtkButton *button_ChangePass, gpointer entry1);
static gboolean cancel_function( GtkButton *button, gpointer data);
static gboolean clear_function( GtkButton *button, gpointer data);


// declaration & initialize variable
gchar message[1000];
gchar message1[1000];
gchar message2[1000];
gchar message3[1000];
gchar message4[1000];
gchar record_user[1000];
gchar record_transaction[1000];
gchar new_user_pin[1000];
gchar trans_type[1000];
gchar trans_status[1000];
gchar trans_balance[1000];
gint transfer_account1=0;
gint index_report;
gchar value[1000];
gchar value2[1000];
gchar value3[1000];
gchar value4[1000];
gchar value5[1000];
gchar value6[1000];
gchar value7[1000];
gchar password[1000];
gchar newPass[1000];
gchar confirmPass[1000];
gint counterPass=0;
gint flags_password=1;
gfloat withdraw_amount1=0.0;
gint counterWithdraw = 0;
gint flags_Withdraw=0;
gint flags_enter=1;
gfloat total_amount1=0.0;
gint flags_balance=1;
gint flags_deposit =0;
gint counterDeposit=0;
gchar deposit_amount[1000];
gfloat deposit_amount1=0.0;
gchar account_no[1000];
gint flags_changesPass=0;
gint counterChangePass=0;
gint counterConfirmPass=0;
gint counterCheck=0;
gint i =0;
gint flags_transfer=0;
gint counterTransfer=0;
gchar account_no[1000];
gchar trans_amount[1000];
gfloat  trans_amount1=0.0;
gint counterAmountTrans=0;
gint index_enter=0;
gchar balance[1000];
gfloat trans_balance1=0.0;
gint flags;
gint confirmPass1=0;
gint first_click=0;
gint index_record=0;
gint record_no=0;
gint record_bil=0;

// declare file variable and pointer
FILE *report_user;
FILE *report_transaction;
char command_statement[BUFFER];

// declare pointer that entered in entry text by user
const char *user_pin;
const char *withdraw_value;
const char *deposit_value;
const char *total_amount_new;
const char *transfer_account;
const char *transfer_amount;
const char *new_password;
const char *confirm_password;


// declare GTK component 
GtkWidget *window;
GtkWidget *box_A;
GtkWidget *box_A1;
GtkWidget *box_A2;
GtkWidget *box_A3;
GtkWidget *box_B;
GtkWidget *box_B1;
GtkWidget *button;
GtkWidget *entry;
GtkWidget *entry1;
GtkWidget *label1;
GtkWidget *label2;
GtkWidget *label3;
GtkWidget *separator;
GtkWidget *separator1;
GtkWidget *separator2;
GtkWidget *table;
GtkWidget *table1;
GtkWidget *button_Balance;
GtkWidget *button_Withdraw;
GtkWidget *button_Deposit;
GtkWidget *button_Transfer;
GtkWidget *button_ChangePass;
GtkWidget *button_Enter;

// declare structure ip address
struct sockaddr_in server_address;

// declare structure for entry text
struct myparam
{
	
	GtkWidget *entry;
};

/**This is where program starts and generates a ATM MAchine with all numbers, all button, labels and entry components.
 * This is where program execution starts which is database and socket are connected to server. All arguments are passed 
   to gtk for processing, which removes any arguments relevant to it. All other arguments are ignored.
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 * @return EXIT_SUCCESS on success, EXIT_FAILURE on failure
 */

/*Main Page for ATM Machine Interface*/
int main( int argc, char *argv[] )
{
    int socket1;

    struct myparam mp;

    if(argc != 2)
   	{
		fprintf(stderr, "%s: usage: %s <server_ip_address>\n", argv[0], argv[0]);
		exit(1);
    	}
	printf("\n");
	
	bzero ((char *) &server_address, sizeof(server_address));
	server_address.sin_family = AF_INET;
	server_address.sin_port = htons (SERV_TCP_PORT);
	inet_pton (AF_INET, argv[1], &server_address.sin_addr);
	
	if( (socket1 = socket(AF_INET, SOCK_STREAM, 0) ) < 0) perror("Client:  socket()error\n");

        if(connect(socket1,(struct sockaddr *)&server_address,sizeof(server_address)) < 0)
	{
		perror("Client: error connect() \n"); 
	}
	else
        {	
		printf("___________________ATM Machine______________________\n\n");
		printf("Connection success with SBH Bank Server \n");
		printf("IP Address: %s \n",inet_ntoa(server_address.sin_addr));


   	 connection1 = mysql_init (NULL);
	if (!connection1)
	{
		fprintf (stderr, "MySQL initialization failed\n");
		exit(EXIT_FAILURE);
	}

	connection1 = mysql_real_connect (connection1, "localhost","ain", "ain151", "atm", 0, NULL, 0);

	if (connection1)
	{
		printf ("Connection successful\n");
	}
	else
	{
		printf ("Connection failed\n");
	}

  

    gtk_init (&argc, &argv);    
      
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    
    g_signal_connect (G_OBJECT (window), "delete_event",G_CALLBACK (close_application),NULL);

    gtk_window_set_title (GTK_WINDOW (window), "ATM Machine");
    gtk_container_set_border_width (GTK_CONTAINER (window), 0);
    gtk_window_set_default_size(GTK_WINDOW(window),230,350);

   

    box_A = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), box_A);
    gtk_widget_show (box_A);   

    box_A2 = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER (box_A2), 5);
    gtk_box_pack_start (GTK_BOX (box_A), box_A2, TRUE, TRUE, 0);
    gtk_widget_show (box_A2); 

    box_A3 = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER (box_A3), 5);
    gtk_box_pack_start (GTK_BOX (box_A), box_A3, TRUE, TRUE, 0);
    gtk_widget_show (box_A3); 

    box_A1 = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER (box_A1), 5);
    gtk_box_pack_start (GTK_BOX (box_A2), box_A1, TRUE, TRUE, 0);
    gtk_widget_show (box_A1);

    box_B1 = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER (box_B1), 5);
    gtk_box_pack_start (GTK_BOX (box_A), box_B1, TRUE, TRUE, 0);
    gtk_widget_show (box_B1);


    box_B = gtk_vbox_new (FALSE, 5);
    gtk_container_set_border_width (GTK_CONTAINER (box_B), 5);
    gtk_box_pack_start (GTK_BOX (box_B1), box_B, TRUE, TRUE, 0);
    gtk_widget_show (box_B);

    label1 = gtk_label_new ("State of Hyderabad Bank ATM");
    gtk_box_pack_start (GTK_BOX (box_A1), label1, TRUE, TRUE, 0);
    gtk_widget_show (label1);

    label2 = gtk_label_new (" ");
    gtk_box_pack_start (GTK_BOX (box_A2), label2, TRUE, TRUE, 0);
    gtk_widget_show (label2);

    label3 = gtk_label_new (" ");
    gtk_box_pack_start (GTK_BOX (box_A3), label3, TRUE, TRUE, 0);
    gtk_widget_show (label3);

 
    entry1 = gtk_entry_new ();
    gtk_widget_set_size_request (GTK_WIDGET (entry1), 100, 150);
    gtk_editable_set_editable(GTK_EDITABLE (entry1),FALSE);
    gtk_entry_set_max_length (GTK_ENTRY (entry1), 100);
    gtk_entry_set_text (GTK_ENTRY (entry1), "Please enter pin number");
    g_signal_connect (G_OBJECT (entry1), "key-release-event", G_CALLBACK (enter_callback), (gpointer) entry1); 
    gtk_box_pack_start (GTK_BOX (box_A1), entry1, TRUE, TRUE, 0);
    gtk_widget_grab_focus(entry1);
    gtk_widget_show (entry1);

    separator1 = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box_A1), separator1, FALSE, TRUE, 0);
    gtk_widget_show (separator1);
     
    mp.entry = gtk_entry_new ();
    gtk_widget_set_size_request (GTK_WIDGET (mp.entry), 10, 30);
    gtk_entry_set_max_length (GTK_ENTRY (mp.entry), 100);
    g_signal_connect (G_OBJECT (mp.entry), "key-release-event", G_CALLBACK (enter_callback), (gpointer) &mp); 
    gtk_box_pack_start (GTK_BOX (box_B1), mp.entry, TRUE, TRUE, 0);
    gtk_widget_grab_focus(mp.entry);
    gtk_widget_show (mp.entry);

    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box_A), separator, FALSE, TRUE, 0);
    gtk_widget_show (separator);

    table1 = gtk_table_new (1, 4, TRUE);
    gtk_container_set_border_width (GTK_CONTAINER ( table1), 10);
    gtk_box_pack_start (GTK_BOX (box_A),  table1, FALSE, TRUE, 0);
    gtk_widget_show (table1);

    button_Balance = gtk_toggle_button_new_with_label ("Balance");
    
    gtk_table_attach_defaults (GTK_TABLE (table1), button_Balance, 0, 1, 0, 1);
    g_signal_connect (G_OBJECT (button_Balance), "clicked",G_CALLBACK(balance_function), (gpointer) &mp);  
    gtk_widget_show (button_Balance);

    button_Withdraw = gtk_toggle_button_new_with_label ("Withdraw");
    gtk_table_attach_defaults (GTK_TABLE (table1), button_Withdraw, 1, 2, 0, 1);
    g_signal_connect (G_OBJECT (button_Withdraw), "clicked",GTK_SIGNAL_FUNC(withdraw_function), (gpointer) entry1);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button_Withdraw), FALSE);
    gtk_widget_show (button_Withdraw);

    button_Deposit = gtk_toggle_button_new_with_label ("Deposit");
    gtk_table_attach_defaults (GTK_TABLE (table1), button_Deposit, 2, 3, 0, 1);
    g_signal_connect (G_OBJECT (button_Deposit), "clicked",G_CALLBACK(deposit_function), (gpointer) entry1); 
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button_Deposit),FALSE); 
    gtk_widget_show (button_Deposit);

    button_Transfer = gtk_toggle_button_new_with_label ("Transfer");
    gtk_table_attach_defaults (GTK_TABLE (table1), button_Transfer, 3, 4, 0, 1);
    g_signal_connect (G_OBJECT (button_Transfer), "clicked",GTK_SIGNAL_FUNC(transfer_function), (gpointer) entry1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button_Transfer),FALSE);  
    gtk_widget_show (button_Transfer);

  
    separator2 = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box_A), separator2, FALSE, TRUE, 0);
    gtk_widget_show (separator2);


    box_B = gtk_vbox_new (FALSE, 10);
    gtk_container_set_border_width (GTK_CONTAINER (box_B), 10);
    gtk_box_pack_start (GTK_BOX (box_A), box_B, FALSE, TRUE, 0);
    gtk_widget_show (box_B);

    table = gtk_table_new (4, 4, TRUE);
    gtk_container_set_border_width (GTK_CONTAINER ( table), 10);
    gtk_box_pack_start (GTK_BOX (box_B),  table, FALSE, TRUE, 0);
    gtk_widget_show (table);

    button = gtk_toggle_button_new_with_label ("7");
    
    gtk_table_attach_defaults (GTK_TABLE (table), button, 0, 1, 0, 1);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp);
    gtk_widget_grab_focus(button); 
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("8");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 2, 0, 1);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp); 
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("9");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 2, 3, 0, 1);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp);
    GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); 
    gtk_widget_show (button);

   
    button_Enter = gtk_toggle_button_new_with_label ("Enter");
    gtk_table_attach_defaults (GTK_TABLE (table), button_Enter, 3, 4, 0, 1);
    g_signal_connect (G_OBJECT (button_Enter), "clicked",G_CALLBACK(enter_function), (gpointer)  &mp); 
    gtk_widget_show (button_Enter);

    button = gtk_button_new_with_label ("4");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 0, 1, 1, 2);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer) &mp); 
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("5");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 2, 1, 2);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp); 
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("6");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 2, 3, 1, 2);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp); 
    gtk_widget_show (button);


    button = gtk_button_new_with_label ("Clear");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 3, 4, 1, 2); 
     g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(clear_function), (gpointer) &mp); 
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("1");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 0, 1, 2, 3);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp); 
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("2");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 2, 2, 3);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp); 
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("3");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 2, 3, 2, 3);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp); 
    gtk_widget_show (button);
  
    button = gtk_button_new_with_label ("Cancel");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 3, 4, 2, 3);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(cancel_function), (gpointer)  &mp); 
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("0");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 0, 1, 3, 4);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp); 
    //gtk_widget_show (button);

    button = gtk_button_new_with_label ("0");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 1, 2, 3, 4);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp); 
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("=");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 2, 3, 3, 4);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(get_focus_click), (gpointer)  &mp); 
    //gtk_widget_show (button);

    button = gtk_button_new_with_label ("Exit");
    gtk_table_attach_defaults (GTK_TABLE (table), button, 3, 4, 3, 4);
    g_signal_connect (G_OBJECT (button), "clicked",G_CALLBACK(close_application), (gpointer)  entry1); 
    gtk_widget_show (button);
   
    gtk_widget_show (table);

    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box_A), separator, FALSE, TRUE, 0);
    gtk_widget_show (separator);

    box_B = gtk_vbox_new (FALSE, 10);
    gtk_container_set_border_width (GTK_CONTAINER (box_B), 10);
    gtk_box_pack_start (GTK_BOX (box_A), box_B, FALSE, TRUE, 0);
    gtk_widget_show (box_B);

    button_ChangePass= gtk_toggle_button_new_with_label ("Change Password");
    g_signal_connect(G_OBJECT(button_ChangePass),"clicked", GTK_SIGNAL_FUNC(changePass_function),(gpointer) entry1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (button_ChangePass),FALSE);
    gtk_widget_set_size_request(button_ChangePass, 20, 30);
    gtk_box_pack_start (GTK_BOX (box_B), button_ChangePass, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (button_ChangePass, GTK_CAN_DEFAULT);
    gtk_widget_grab_default (button_ChangePass);
    gtk_widget_show (button_ChangePass);
 
    gtk_widget_show (window);
    gtk_main ();

     send (socket1,"Report sent to SBH mailing list. End of ATM System.", BUFSIZE,0); 
    }
   
    mysql_close (connection1);

    exit(EXIT_SUCCESS);
  
    close (socket1); 

    return 0;
}

/**This function is to called when user presses button to enter number in entry text.
   Also to display instruction and message in other entry text 
 * @param *entry Widget which generated the entry
 * @param *event Widget which generated the event
 * @param data any additional data passed while generating signal  
 */
static void enter_callback( GtkWidget *entry, GdkEventKey *event, gpointer data)
{
  
   const gchar *entry_text;
   
 
  entry_text=gtk_entry_get_text (GTK_ENTRY ( entry));
  gtk_entry_append_text(GTK_ENTRY(data),entry_text);
  
}


/** This is called on pressing button to exit from system.
 * It calls gtk_main_quit() to end gtk_main and return to main()
 * @param *event GdkEvent which generated the event.
 * @param *widget GtkWidget allow user press the button
 * @return FALSE if you want to closing, TRUE otherwise  
 */
static gboolean close_application( GtkWidget *widget,GdkEvent  *event)
{
  	gtk_main_quit ();
  	return FALSE;
}


/** This is called on pressing button to cancel from do any transaction.
 * @param *button GtkButton allow user press the cancel button
 * @param data any additional data passed while generating signal  
 * @return TRUE if you want to cancle transaction, FALSE otherwise  
 */
static gboolean cancel_function( GtkButton *button, gpointer data)
{
        
         struct myparam *mp=data;

  	gtk_entry_set_text (GTK_ENTRY (entry1), "Out of System.Thank You");
        gtk_label_set_text(GTK_LABEL(label3),"");
	gtk_label_set_text(GTK_LABEL(label2),"");
        first_click=0;
        flags_enter=1;
  	gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
        gtk_entry_set_visibility(GTK_ENTRY (mp->entry), FALSE);
        return TRUE;
}


/** This is called on pressing button when to clear value shown in entry text.
 * @param *button GtkButton allow user press the cancel button
 * @param data any additional data passed while generating signal  
 * @return TRUE if you want to clear transaction, FALSE otherwise  
 */
static gboolean clear_function( GtkButton *button, gpointer data)
{
       
         struct myparam *mp=data;

  	
        first_click=0;
        flags_enter=1;
  	gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
        counterPass=0;
	counterWithdraw=0;
	counterDeposit=0;
	counterChangePass=0;
	counterConfirmPass=0;
	counterTransfer=0;
	counterAmountTrans=0;
       
        return TRUE;
}


/** This is called on pressing button when user want to enter pin number,
    amount of money to withdrawal, deposit or transfer and accout no 
    to make transfer money. User allow to enter 4 digit for pin number,
    at most 5 digit number for amount of withdrawal/deposit/transfer and
    7 digit number for account no. 
    Pin number is setting as an invisible for security and authorized.
 * @param *button GtkButton allow user press the digit button
 * @param data any additional data passed while generating signal  
 * @return TRUE if you want to clear transaction, FALSE otherwise  
 */
static gboolean get_focus_click (GtkButton *button, gpointer data)
{     
    struct myparam *mp = data;
     //LOGIN

     if (counterPass <4 && flags_password==1)
     {
      
      //copy value from button 
     strcpy(value,gtk_button_get_label(button));
     gtk_entry_set_visibility(GTK_ENTRY (mp->entry), FALSE);
       //compare value from button with number
        if(strcmp(value,"1")==0) 
        {
            // append the value in text field            
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"1");	                     
        } 

       else if(strcmp(value,"2")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"2"); 	  
        }
       
      else if(strcmp(value,"3")==0)
      {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"3");            
      }
 	     
         else if(strcmp(value,"4")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"4");			   
        } 
        else if(strcmp(value,"5")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"5");  		  
        }
       
        else if(strcmp(value,"6")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"6");   
        } 
        else  if(strcmp(value,"7")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"7");    
        } 
         else if(strcmp(value,"8")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"8");    
        }
         else if(strcmp(value,"9")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"9"); 
        }
        else  if(strcmp(value,"0")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"0");  
        }
       
       counterPass++;
   }

      // WITHDRAW
      if (counterWithdraw <= 5 && flags_Withdraw==1)
      {
        flags_enter=2;
        strcpy(value2,gtk_button_get_label(button));
        gtk_entry_set_visibility(GTK_ENTRY (mp->entry), TRUE);

        if(strcmp(value2,"1")==0) 
        {
            // append the value in text field
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"1");	           
        } 

       else if(strcmp(value2,"2")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"2"); 	   
        }
       
      else if(strcmp(value2,"3")==0)
      {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"3");            
      }
 	     
         else if(strcmp(value2,"4")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"4");	    		   
        } 
        else if(strcmp(value2,"5")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"5");			  
        }
       
        else if(strcmp(value2,"6")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"6");	   
        } 
      
       
        else  if(strcmp(value2,"7")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"7");          
        } 
         else if(strcmp(value2,"8")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"8");	    
        }
         else if(strcmp(value2,"9")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"9");	 
        }
        else  if(strcmp(value2,"0")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"0");	  
        }
       counterWithdraw++;
  }   

     //DEPOSIT
     if (counterDeposit <= 5 && flags_deposit==1)
      {
        flags_enter=3;
        strcpy(value3,gtk_button_get_label(button));
	gtk_entry_set_visibility(GTK_ENTRY (mp->entry), TRUE);

        if(strcmp(value3,"1")==0) 
        {
            // append the value in text field
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"1");	           
        } 

       else if(strcmp(value3,"2")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"2"); 	    
        }
       
      else if(strcmp(value3,"3")==0)
      {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"3");          
      }
 	     
         else if(strcmp(value3,"4")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"4");	   		   
        } 
        else if(strcmp(value3,"5")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"5");		  
        }
       
        else if(strcmp(value3,"6")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"6");	    
        } 
      
       
        else  if(strcmp(value3,"7")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"7");           
        } 
         else if(strcmp(value3,"8")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"8");	  
        }
         else if(strcmp(value3,"9")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"9");
        }
        else  if(strcmp(value3,"0")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"0");
        }
       counterDeposit++;
  } 

       //CHANGES NEW PASSWORD
      if (counterChangePass <4 && flags_changesPass==1)
     {
       flags_enter=6;
      //copy value from button 
     strcpy(value6,gtk_button_get_label(button));
     gtk_entry_set_visibility(GTK_ENTRY (mp->entry), FALSE);
       //compare value from button with number
        if(strcmp(value6,"1")==0) 
        {
            // append the value in text field
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"1");

	   // append value using strcat function
	   strcat(newPass,"1");                   
        } 

       else if(strcmp(value6,"2")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"2"); 

	    strcat(newPass,"2");
        }
       
      else if(strcmp(value6,"3")==0)
      {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"3"); 

           strcat(newPass,"3"); 
      }
 	     
         else if(strcmp(value6,"4")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"4");

	    strcat(newPass,"4");		   
        } 
        else if(strcmp(value6,"5")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"5");

	  strcat(newPass,"5");
		  
        }
       
        else if(strcmp(value6,"6")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"6");

	    strcat(newPass,"6");
        } 
        else  if(strcmp(value6,"7")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"7");

	   strcat(newPass,"7");
           
        } 
         else if(strcmp(value6,"8")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"8");

	    strcat(newPass,"8");
        }
         else if(strcmp(value6,"9")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"9");

	   strcat(newPass,"9");
        }
        else  if(strcmp(value6,"0")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"0");

	   strcat(newPass,"0");
        }
       
       counterChangePass++;
   }


 //CONFIRM NEW PASSWORD

       if (counterConfirmPass <4 && flags_changesPass==2)
     {
       flags_enter=7;
      //copy value from button 
     strcpy(value7,gtk_button_get_label(button));
     gtk_entry_set_visibility(GTK_ENTRY (mp->entry), FALSE);
       //compare value from button with number
        if(strcmp(value7,"1")==0) 
        {
            // append the value in text field
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"1");

	   // append value using strcat function
	   strcat(confirmPass,"1");                   
        } 

       else if(strcmp(value7,"2")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"2"); 

	    strcat(confirmPass,"2");
        }
       
      else if(strcmp(value7,"3")==0)
      {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"3"); 

           strcat(confirmPass,"3"); 
      }
 	     
         else if(strcmp(value7,"4")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"4");

	    strcat(confirmPass,"4");		   
        } 
        else if(strcmp(value7,"5")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"5");

	  strcat(confirmPass,"5");
		  
        }
       
        else if(strcmp(value7,"6")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"6");

	    strcat(confirmPass,"6");
        } 
        else  if(strcmp(value7,"7")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"7");

	   strcat(confirmPass,"7");
           
        } 
         else if(strcmp(value7,"8")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"8");

	    strcat(confirmPass,"8");
        }
         else if(strcmp(value7,"9")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"9");

	   strcat(confirmPass,"9");
        }
        else  if(strcmp(value7,"0")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"0");

	   strcat(confirmPass,"0");
        }
       
       counterConfirmPass++;
   }

    //TRANSFER (INSERT ACCOUNT NO)
   if (counterTransfer <7 && flags_transfer==1)
    {
        flags_enter=4;
        strcpy(value4,gtk_button_get_label(button));
	gtk_entry_set_visibility(GTK_ENTRY (mp->entry), TRUE);

        if(strcmp(value4,"1")==0) 
        {
            // append the value in text field
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"1");
           
        } 

       else if(strcmp(value4,"2")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"2"); 

        }
       
      else if(strcmp(value4,"3")==0)
      {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"3"); 
      }
 	     
         else if(strcmp(value4,"4")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"4");		   
        } 
        else if(strcmp(value4,"5")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"5");
		  
        }
       
        else if(strcmp(value4,"6")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"6");

        } 
      
       
        else  if(strcmp(value4,"7")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"7");
           
        } 
         else if(strcmp(value4,"8")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"8");
	 
        }
         else if(strcmp(value4,"9")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"9");
	  
        }
        else  if(strcmp(value4,"0")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"0");

        }
       counterTransfer++;
  } 
    
     //TRANSFER (INSERT AMOUNT)
    if (counterAmountTrans <5 && flags_transfer==2)
    {
        flags_enter=5;
        strcpy(value5,gtk_button_get_label(button));
	gtk_entry_set_visibility(GTK_ENTRY (mp->entry), TRUE);

        if(strcmp(value5,"1")==0) 
        {
            // append the value in text field
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"1");           
        } 

       else if(strcmp(value5,"2")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"2"); 

        }
       
      else if(strcmp(value5,"3")==0)
      {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"3"); 
      }
 	     
         else if(strcmp(value5,"4")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"4");
	   
        } 
        else if(strcmp(value5,"5")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"5");
		  
        }
       
        else if(strcmp(value5,"6")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"6");

        } 
      
       
        else  if(strcmp(value5,"7")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"7");
           
        } 
         else if(strcmp(value5,"8")==0)
        {
            gtk_entry_append_text(GTK_ENTRY(mp->entry),"8");
        }
         else if(strcmp(value5,"9")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"9");  
        }
        else  if(strcmp(value5,"0")==0)
        {
           gtk_entry_append_text(GTK_ENTRY(mp->entry),"0");	  
        }
       counterAmountTrans++;
  } 
    

    return TRUE;
}

/** This is called on pressing button after user enter pin no/amount/account no
    in entry text. In this function to allow user to connect database to display
    data according type of transaction.   
 * @param *button_Enter GtkButton allow user press the enter button
 * @param data any additional data passed while generating signal to hold value entered by user  
 * @return TRUE if you allow to continue any transaction, FALSE otherwise  
 */

static gboolean enter_function (GtkButton *button_Enter, gpointer data)
{ 
        struct myparam *mp = data;
        char sql_statement[4096];
	int result_value;
        unsigned int field_count;

    	field_count = 0;
	
       
        user_pin =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)mp->entry));

        withdraw_value =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)mp->entry));
	
	deposit_value =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)mp->entry));
	
	transfer_account =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)mp->entry));

	transfer_amount =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)mp->entry));

	new_password =gtk_entry_get_text(GTK_ENTRY((GtkWidget *)mp->entry));
    
        confirm_password=gtk_entry_get_text(GTK_ENTRY((GtkWidget *)mp->entry));
    

       if(flags_enter==1) //hold pin no
       {    
		
	  sprintf(sql_statement,"select name from user where user_pin = '%s' ",user_pin);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		printf ("Pin Incorrect\n");
	        gtk_entry_set_text (GTK_ENTRY (entry1), "Invalid pin number. Try Again");
	}
	else
	{
		
               result1 = mysql_use_result (connection1);
                index_enter=1;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  display_row1 ();
                                 
 				
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		         gtk_entry_set_text (GTK_ENTRY (entry1), "Invalid pin number. Try Again"); 
			printf ("Pin Incorrect\n");
                 }
         
         
        mysql_free_result(result1);    
        
        }
       
        sprintf(sql_statement,"select user_pin from user where name = '%s' ",message);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_enter=2;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  display_row1 ();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		     
                }
          
        mysql_free_result(result1);       
        }

          sprintf(sql_statement,"select no_account from user where user_pin = '%s' ",message1);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_enter=4;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  display_row1 ();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		    
                }
          
        mysql_free_result(result1);       
        }
                         
 }

       else if(flags_enter==2) //hold balance after withdrawal
       {

             sprintf(sql_statement,"select balance from user where user_pin = '%s' ",message1);

	      result_value = mysql_query (connection1, sql_statement);
	
		if (result_value)
		{
			printf ("select failed as : %s\n", mysql_error (connection1));
			
		}
		else
		{
               		result1 = mysql_use_result (connection1);
                	
	    		if (result1)
	    		{
    				while ((sqlrow = mysql_fetch_row (result1)))
                                count_withdrawal ();
 				gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
				
                               	
				 if (mysql_errno (connection1))
				{
		    			printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
				}  	                    
                        	     
       		        }
                 	else if (result1)
                 	{
                     		printf ("select failed as : %s\n", mysql_error (connection1));
		     		
                	}
          updated_record();
	  insert_report();
        mysql_free_result(result1);   
            
        }

	 sprintf(sql_statement,"select name, no_account,balance from user where user_pin = '%s' ",message1);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_record=1;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  create_report();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		    
                }
          
        mysql_free_result(result1);       
        }

	 sprintf(sql_statement,"select transaction, amount, remark from report where no_id = '%d' ",record_no);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_record=2;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  create_report();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		    
                }
         send_mail(); 
        mysql_free_result(result1);       
        }

    }

	 else if(flags_enter==3) //hold balance after deposit
       {

             sprintf(sql_statement,"select balance from user where user_pin = '%s' ",message1);

	      result_value = mysql_query (connection1, sql_statement);
	
		if (result_value)
		{
			printf ("select failed as : %s\n", mysql_error (connection1));
			
		}
		else
		{
               		result1 = mysql_use_result (connection1);
                	
	    		if (result1)
	    		{
    				while ((sqlrow = mysql_fetch_row (result1)))
                                count_deposit ();
 				gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
				
                               	
				 if (mysql_errno (connection1))
				{
		    			printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
				}  	                    
                        	     
       		        }
                 	else if (result1)
                 	{
                     		printf ("select failed as : %s\n", mysql_error (connection1));
		     		
                	}
		
          	updated_record();
		 insert_report();
       		 mysql_free_result(result1);   
            
        	}

		 sprintf(sql_statement,"select name, no_account,balance from user where user_pin = '%s' ",message1);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_record=1;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  create_report();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		    
                }
          
        mysql_free_result(result1);       
        }

	 sprintf(sql_statement,"select transaction, amount, remark from report where no_id = '%d' ",record_no);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_record=2;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  create_report();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		    
                }
         send_mail(); 
        mysql_free_result(result1);       
        }
		
  	}
          
        else if(flags_enter==4) //hold  account no to transfer
       {
		
		
	      sprintf(sql_statement,"select no_account from user where no_account = '%s' ",transfer_account);

	      result_value = mysql_query (connection1, sql_statement);
	
		if (result_value)
		{
			printf ("select failed as : %s\n", mysql_error (connection1));
			
		}
		else
		{
               		result1 = mysql_use_result (connection1);
             
	    		if (result1)
	    		{
    				while ((sqlrow = mysql_fetch_row (result1)))
                                display_row1 ();
				
				 if (mysql_errno (connection1))
				{
		    			printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
				}  	                    
                        	     
       		        }
                 	else if (result1)
                 	{
                     		printf ("select failed as : %s\n", mysql_error (connection1));
		     		
                	}
          
        mysql_free_result(result1);   
            
         }

	 sprintf(sql_statement,"select balance from user where no_account = '%s' ",transfer_account);

	      result_value = mysql_query (connection1, sql_statement);
	
		if (result_value)
		{
			printf ("select failed as : %s\n", mysql_error (connection1));
		}
		else
		{
               		result1 = mysql_use_result (connection1);
                	flags_transfer=2; 
	    		if (result1)
	    		{
    				while ((sqlrow = mysql_fetch_row (result1)))
                                display_row1 ();
				gtk_entry_set_text (GTK_ENTRY (entry1), "Enter amount to transfer:");
 				gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
				
                               	
				 if (mysql_errno (connection1))
				{
		    			printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
				}  	                    
                        	     
       		        }
                 	else if (result1)
                 	{
                     		printf ("select failed as : %s\n", mysql_error (connection1));
		     		
                	}
          
        mysql_free_result(result1);   
            
         }
		          		
           	      	
       }


        else if(flags_enter==5) //hold amount to transfer
       {
                

                sprintf(sql_statement,"select balance from user where user_pin = '%s' ",message1);

	      	result_value = mysql_query (connection1, sql_statement);
	
		if (result_value)
		{
			printf ("select failed as : %s\n", mysql_error (connection1));
			
		}
		else
		{
               		result1 = mysql_use_result (connection1);
                	
	    		if (result1)
	    		{
    				while ((sqlrow = mysql_fetch_row (result1)))
                                transfer_money ();
 				gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
				
                               	
				 if (mysql_errno (connection1))
				{
		    			printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
				}  	                    
                        	     
       		        }
                 	else if (result1)
                 	{
                     		printf ("select failed as : %s\n", mysql_error (connection1));
		     		
                	}
	updated_record();
	insert_report();
	updated_transfer_account();
        mysql_free_result(result1);   
            
        } 
	sprintf(sql_statement,"select name, no_account,balance from user where user_pin = '%s' ",message1);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_record=1;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  create_report();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		    
                }
          
        mysql_free_result(result1);       
        }

	 sprintf(sql_statement,"select transaction, amount, remark from report where no_id = '%d' ",record_no);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_record=2;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  create_report();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		    
                }
         send_mail(); 
        mysql_free_result(result1);       
        }
	
             	
    }

         else if(flags_enter==6) //hold new password
       {
             
             	gtk_entry_set_text (GTK_ENTRY (entry1), "Enter confirm new password");
                gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                flags_changesPass=2;
        }	
        
	else if(flags_enter==7) //hole confirm password
       {
                while (counterCheck !=4)
                { 
			if (strcmp(newPass,confirmPass)==0)
                        {
				flags=1;
                        }
                        else
                        {
				gtk_entry_set_text (GTK_ENTRY (entry1), "Invalid new password. Try Again");
				gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
				flags=0;
				
			}
                     i++;
                     counterCheck++;
               }

		if(flags==1) //hold correct new & confrim password
       		{

             		sprintf(sql_statement,"select user_pin from user where user_pin = '%s' ",message1);

	      		result_value = mysql_query (connection1, sql_statement);
	
			if (result_value)
			{
				printf ("select failed as : %s\n", mysql_error (connection1));
			}
			else
			{
               			result1 = mysql_use_result (connection1);
	    			if (result1)
	    			{
    					while ((sqlrow = mysql_fetch_row (result1)))
                                	 display_row1 ();
					
 					gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
				
                               	
					 if (mysql_errno (connection1))
					{
		    				printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
					}  	                    
                        	     
       		       		 }
                 		else if (result1)
                 		{
                     			printf ("select failed as : %s\n", mysql_error (connection1));
		     		
                		}
          		updated_password_record();
	  		insert_report();
        		mysql_free_result(result1);   
            
        		}

			sprintf(sql_statement,"select name, no_account,balance from user where user_pin = '%s' ",message1);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_record=1;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  create_report();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		    
                }
          
        mysql_free_result(result1);       
        }

	 sprintf(sql_statement,"select transaction, amount, remark from report where no_id = '%d' ",record_no);

	result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
		
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_record=2;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                                  create_report();	
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                             
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
                 else if (result1)
                 {
                     printf ("select failed as : %s\n", mysql_error (connection1));
		    
                }
         send_mail(); 
        mysql_free_result(result1);       
        }
		   }
		else if(flags==0) //hold incorrect new & confirm password
		{
			gtk_entry_set_text (GTK_ENTRY (entry1), "Invalid new password. Try Again");
			gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
		}           	
                
        }
   return TRUE;
}


/** This is called after user connected to database and want to display message.
    Message will be display after system finish retrieved data from database according
    what kind of data to be selected.   
*/
void display_row1 ()
{
        
    	unsigned int field_count;

    	field_count = 0;

        if ( flags_enter==1 && index_enter==1)//hold name
       {
    		while (field_count < mysql_field_count (connection1))
    		{
			printf ("Welcome %s ", sqlrow[field_count]); 
        	        sprintf(message, "%s",sqlrow[field_count]);
			field_count++;
    		} 
                first_click =1;
        	gtk_label_set_text(GTK_LABEL(label2),message);
		gtk_entry_set_text(GTK_ENTRY(entry1),"Please select menu transaction");
    		printf ("\n");
	}

       else if (flags_enter ==1 && index_enter==2) //hold password
      {
	while (field_count < mysql_field_count (connection1))
    	{
        	sprintf(message1, "%s",sqlrow[field_count]);
	        field_count++;
    	} 
    	printf ("\n");
     }

      else if (flags_enter ==1 && index_enter==4) //hold password
      {
	while (field_count < mysql_field_count (connection1))
    	{
        	sprintf(message4, "Account No: %s",sqlrow[field_count]);
	        field_count++;
    	} 
        gtk_entry_set_text(GTK_ENTRY(entry1),"Please select menu transaction");
        gtk_label_set_text(GTK_LABEL(label3),message4);
    	printf ("\n");
     }

      else if (flags_balance ==1 && index_enter==3) //hold balance when clik balance button
      {
	while (field_count < mysql_field_count (connection1))
    	{
		printf ("From database Balance Available: %s ", sqlrow[field_count]);
                sprintf(message2, "%s",sqlrow[field_count]);
		field_count++;
    	} 
        gtk_entry_set_text(GTK_ENTRY(entry1),message2);
    	printf ("\n");
     }

     else if (flags_transfer==1 && flags_enter==4) //hold transfered account
      {
	while (field_count < mysql_field_count (connection1))
    	{
		printf ("transfer account: %s ", sqlrow[field_count]);
                sprintf(message3, "%s",sqlrow[field_count]);
		field_count++;
    	} 
    	printf ("\n");
     }

     else if (flags_transfer==2 && flags_enter==4) //hold transfered balance
      {
	while (field_count < mysql_field_count (connection1))
    	{
		printf ("transfer balance: %s ", sqlrow[field_count]);
                sprintf(trans_balance, "%s",sqlrow[field_count]);
		field_count++;
    	} 
    	printf ("\n");
     }

	else if (flags==1 && flags_enter==7) //hold transfered balance
      {
	while (field_count < mysql_field_count (connection1))
    	{
		printf ("User pin: %s ", sqlrow[field_count]);
                sprintf(new_user_pin, "%s",sqlrow[field_count]);
		field_count++;
    	} 
    	printf ("\n");
     }
}


/** This is called when system want to be create report file to write record transaction from database.
    Here, has two file which are report user and report transaction. Report user will retrieve data
    about infromation about user such as name, account no and balance available currently.
    Report transaction will retrieve data latest transaction done by user.   
*/

void create_report()
{
	
    	unsigned int field_count;
	
    	field_count = 0;

        if (index_record==1) //hold record user
       {
		report_user=fopen("report_user.txt", "w");
		if(report_user==NULL)
    		{
			fprintf(stderr, "Cant open file '%s' for writing\n", "report_user.txt");
			perror("");
			exit(EXIT_FAILURE);
    		}

    		while (field_count < mysql_field_count (connection1))
    		{
			printf ("Report: %s ", sqlrow[field_count]); 
        	        sprintf(record_user, "%s",sqlrow[field_count]);
			fprintf(report_user, " %s ", record_user);		        
			field_count++;
    		} 
    		printf ("\n");
		fclose(report_user);
		printf("Closed file '%s'\n", "report_user.txt");
	}

	 else if (index_record==2) //hold record transaction
       {
		report_transaction=fopen("report_transaction.txt", "w");
		if(report_transaction==NULL)
    		{
			fprintf(stderr, "Cant open file '%s' for writing\n", "report_transaction.txt");
			perror("");
			exit(EXIT_FAILURE);
    		}

    		while (field_count < mysql_field_count (connection1))
    		{
			printf ("Report: %s ", sqlrow[field_count]); 
        	        sprintf(record_transaction, "%s",sqlrow[field_count]);
			fprintf(report_transaction, " %s ", record_transaction);		        
			field_count++;
    		} 
    		printf ("\n");
		fclose(report_transaction);
		printf("Closed file '%s'\n", "report_transaction.txt");
	}
}

/** This is called when system want to send report user and report transaction file. 
    All the reports will be send to user through by student mail and bank (SBH mail)
    with attachment file for their references. 
*/	

void send_mail()
{
	 sprintf(command_statement, "mutt -s Report SBH -a /home/ain/st/200905027/project/report_user.txt hamidon.bt@students.iiit.ac.in < /home/ain/st/200905027/project/record.txt");
         system(command_statement);

	sprintf(command_statement, "mutt -s Report SBH -a /home/ain/st/200905027/project/report_transaction.txt hamidon.bt@students.iiit.ac.in < /home/ain/st/200905027/project/record.txt");
         system(command_statement);

        printf("report file sent to mail succesfully");
	printf ("\n");
}


/** This is called when user want to transfer money to other account.In this function we need to 
    convert amount to float type to easy for calculation process. User can't transfer money more than
    rs50000 in one time. otherwise transaction will be failed
*/
void transfer_money ()
{
      
    	unsigned int field_count;
	
    	field_count = 0;

	strcat(trans_type,"transfer money"); 
        printf ("Transfer Account: %d ",  transfer_account1);

    	while (field_count < mysql_field_count (connection1)) //hold balance from dtbase for withdraw
    	{
        	sprintf(message2, "%s",sqlrow[field_count]);

		//convert char value to float to allow calculation
                trans_amount1=atof(transfer_amount);
            	total_amount1=atof(message2);
                                
                printf ("Transfer Amount  from user: %.2f ", trans_amount1);
            	printf ("take Amount from dtbase: %.2f ",  total_amount1);
            			 

                if (trans_amount1 < 50000)
             	{
                	total_amount1 = total_amount1 - trans_amount1;
                	printf ("New balance %.2f ",  total_amount1);
                        
		        gtk_entry_set_text(GTK_ENTRY(entry1),"Transfer amount process is succesfully"); 
			strcat(trans_status,"succesfully"); 
                       
             	}

		else
             	{
			gtk_entry_set_text (GTK_ENTRY (entry1), "Invalid Value. Check your balance");	
			strcat(trans_status,"failed");
			
             	}	
                
		field_count++;
                
    	}      
         
}

/** This is called when user want to make withdrawal transaction from their account.In this function we need to 
    convert amount to float type to easy for calculation process. User can't make withdrawal money more than
    total amount of money available in their account. otherwise transaction will be failed
*/

void count_withdrawal ()
{
      
    	unsigned int field_count;
	
    	field_count = 0;
	strcat(trans_type,"withdrawal"); 
	

       
    	while (field_count < mysql_field_count (connection1)) //hold balance from dtbase for withdraw
    	{
        	sprintf(message2, "%s",sqlrow[field_count]);

                withdraw_amount1=atof(withdraw_value);
            	total_amount1=atof(message2);
                                
                printf ("Withdrawal Amount  from user: %.2f ",  withdraw_amount1);
            	printf ("take Amount from dtbase: %.2f ",  total_amount1);
            			 

                if (total_amount1 > withdraw_amount1)
             	{
                	total_amount1 = total_amount1 - withdraw_amount1;
                	printf ("New balance %.2f ",  total_amount1);
                        
		        gtk_entry_set_text(GTK_ENTRY(entry1),"Withdrawal process is succesfully"); 
			strcat(trans_status,"succesfully"); 
                       
             	}

		else
             	{
			gtk_entry_set_text (GTK_ENTRY (entry1), "Invalid Value. Check your balance");	
			strcat(trans_status,"failed");
			
             	}	
                
		field_count++;
                
    	}      
         
}


/** This is called when user want to add money to their account.In this function we need to 
    convert amount to float type to easy for calculation process. User can't add money more than
    rs50000 in one time. otherwise transaction will be failed
*/
void count_deposit ()
{
      
    	unsigned int field_count;
	
    	field_count = 0;
	strcat(trans_type,"deposit"); 
       
    	while (field_count < mysql_field_count (connection1)) //hold balance from dtbase for withdraw
    	{
		
        	sprintf(message2, "%s",sqlrow[field_count]);

                deposit_amount1=atof(deposit_value);
            	total_amount1=atof(message2);
                                
                printf ("Deposit Amount  from user: %.2f ",  deposit_amount1);
            	printf ("Take amount from dtbase: %.2f ",  total_amount1);
            			 

                if (deposit_amount1 < 50000)
             	{
                	total_amount1 = total_amount1 + deposit_amount1;
                	printf ("New balance %.2f ",  total_amount1);   
		        gtk_entry_set_text(GTK_ENTRY(entry1),"Deposit process is succesfully");
                        strcat(trans_status,"succesfully"); 
             	}

		else
             	{
			gtk_entry_set_text (GTK_ENTRY (entry1), "Invalid Value. Check your balance");	
			strcat(trans_status,"failed"); 
             	}	
                
		field_count++;
                
    	}      
         
}


/** This is called when user change the new password and updated it into database system.
*/
void updated_password_record()
{
	char sql_statement[4096];
	
	strcat(trans_type,"change password"); 
  	
	int result;

   	sprintf(sql_statement, "update user set user_pin='%s' where user_pin=%s",confirmPass,new_user_pin);
	result = mysql_query (connection1, sql_statement);

	if (!result)
	{
	    gtk_entry_set_text (GTK_ENTRY (entry1), "Change password process is succesfully");
	    printf ("Updated %lu rows\n", (unsigned long) mysql_affected_rows (connection1));
	    strcat(trans_status,"succesfully");
	}
	else
	{
		fprintf (stderr, "Updated failed as %d: %s\n", mysql_errno (connection1), mysql_error (connection1));
		strcat(trans_status,"failed"); 
	}	
}



/** This is called when user make tranfer money to other account which is updated balance for other account
    according the account no.In this function we need to convert amount to float type to easy for calculation process.
*/
void updated_transfer_account()
{
	char sql_statement[4096];
	int result;

	trans_balance1=atof(trans_balance);
	trans_balance1 = trans_balance1 + trans_amount1;

   	sprintf(sql_statement, "update user set balance='%.2f' where no_account=%s",trans_balance1,message3);
	result = mysql_query (connection1, sql_statement);

	if (!result)
	{
	    printf ("Updated %lu rows\n", (unsigned long) mysql_affected_rows (connection1));
	}
	else
	{
		fprintf (stderr, "Updated failed as %d: %s\n", mysql_errno (connection1), mysql_error (connection1));
	}	
}


/** This is called when system want to updated balance in database after user did the withdrawal, deposit and transfer transaction.
*/
void updated_record()
{
	char sql_statement[4096];
	int result;

   	sprintf(sql_statement, "update user set balance='%.2f' where user_pin=%s",total_amount1,message1);
	result = mysql_query (connection1, sql_statement);

	if (!result)
	{
	    printf ("Updated %lu rows\n", (unsigned long) mysql_affected_rows (connection1));
	}
	else
	{
		fprintf (stderr, "Updated failed as %d: %s\n", mysql_errno (connection1), mysql_error (connection1));
	}	
}


/** This is called when system want to save record transaction in database after user did the withdrawal, 
    change password, deposit and transfer transaction.
*/
void insert_report()
{
	char sql_statement[4096];
	int result;
	
	record_no=record_bil+1;
	
	 if(strcmp(trans_type,"withdrawal")==0) 
	{
   		sprintf(sql_statement,"INSERT into report values('%d','%s','%s','%.2f','%s')",record_no,message1,trans_type,withdraw_amount1,trans_status);
		result = mysql_query (connection1, sql_statement);

		if (result==0)
		{
		    printf ("New record inserted successfully.\n");
		}
		else
		{
		     fprintf (stderr, "Could not insert data as %d: %s\n",mysql_errno (connection1),mysql_error (connection1));
        	     printf("Please try again\n");		
		}
           
	}

	 else if(strcmp(trans_type,"deposit")==0) 
	{
   		sprintf(sql_statement, "INSERT into report values('%d','%s','%s','%.2f','%s')",record_no,message1,trans_type,deposit_amount1,trans_status);
		result = mysql_query (connection1, sql_statement);

		if (result==0)
		{
		    printf ("New record inserted successfully.\n");
		}
		else
		{
		    fprintf (stderr, "Could not insert data as %d: %s\n",mysql_errno (connection1),mysql_error (connection1));
        	    printf("Please try again\n");		
		}
	   
	}

	 else if(strcmp(trans_type,"transfer money")==0) 
	{
   		sprintf(sql_statement, "INSERT into report values('%d','%s','%s','%.2f','%s')",record_no,message1,trans_type,trans_amount1,message3);
		result = mysql_query (connection1, sql_statement);

		if (result==0)
		{
		    printf ("New record inserted successfully.\n");
		}
		else
		{
		    fprintf (stderr, "Could not insert data as %d: %s\n",mysql_errno (connection1),mysql_error (connection1));
        	    printf("Please try again\n");		
		}
	   
	}

	else if(strcmp(trans_type,"change password")==0) 
	{
   		sprintf(sql_statement, "INSERT into report values('%d','%s','%s','%s','%s')",record_no,message1,trans_type,confirmPass,trans_status);
		result = mysql_query (connection1, sql_statement);

		if (result==0)
		{
		    printf ("New record inserted successfully.\n");
		}
		else
		{
		    fprintf (stderr, "Could not insert data as %d: %s\n",mysql_errno (connection1),mysql_error (connection1));
        	    printf("Please try again\n");		
		}
	   
	}
}


/**This function is to called when user presses button to check their balance available currently.
 * @param *button_Balance GtkButton which allow pressed by user to make transaction
 * @param data any additional data passed while generating signal  
 */
static gboolean balance_function (GtkButton *button_Balance, gpointer data)
{ 
    
    struct myparam *mp = data;
    char sql_statement[4096];
    int result_value;

    if (first_click ==0)
   {
	gtk_entry_set_text (GTK_ENTRY (entry1), "Please enter pin number"); 
   }
   else if (first_click ==1)

    //if (flags_balance ==1)
     {
        
         sprintf(sql_statement,"select balance from user where user_pin = '%s' ",message1);

	  result_value = mysql_query (connection1, sql_statement);
	
	if (result_value)
	{
		printf ("select failed as : %s\n", mysql_error (connection1));
	}
	else
	{
               result1 = mysql_use_result (connection1);
                index_enter=3;
	    	if (result1)
	    	{
    			while ((sqlrow = mysql_fetch_row (result1)))
                               
		   		display_row1 ();
                            gtk_entry_set_text(GTK_ENTRY(mp->entry),"");
                        if (mysql_errno (connection1))
			{
		    		printf ("Error occurred while retrieving data : %s\n", mysql_error (connection1));
			}       
       		 }
             mysql_free_result(result1);   
         }
      }    
         
     return TRUE;
}


/**This function is to called when user presses button to make add money into their account.
 * @param *button_Deposit GtkButton which allow pressed by user to make transaction
 * @param entry1 gpointer to display instruction 
 */
static gboolean deposit_function (GtkButton *button_Deposit, gpointer entry1)
{ 

  if (first_click ==0)
   {
	gtk_entry_set_text (GTK_ENTRY (entry1), "Please enter pin number"); 
   }
   else if (first_click ==1)
  {

   	flags_deposit=1;
   	gtk_entry_set_text (GTK_ENTRY (entry1), "Enter deposit amount:");        
   }
              
     return TRUE;
}


/**This function is to called when user presses button to make transfer money into other account.
 * @param *button_Transfer GtkButton which allow pressed by user to make transaction
 * @param entry1 gpointer to display instruction 
 */
static gboolean transfer_function (GtkButton *button_Transfer, gpointer entry1)
{ 
   
   if (first_click ==0)
   {
	gtk_entry_set_text (GTK_ENTRY (entry1), "Please enter pin number"); 
   }
   else if (first_click ==1)
  {

   	flags_transfer=1;
   	gtk_entry_set_text (GTK_ENTRY (entry1), "Enter account no:");        
  }
           
    return TRUE;
}


/**This function is to called when user presses button to changes password.
 * @param *button_Transfer GtkButton which allow pressed by user to make transaction
 * @param entry1 gpointer to display instruction 
 */
static gboolean changePass_function (GtkButton *button_ChangePass, gpointer entry1)
{ 

    if (first_click ==0)
   {
	gtk_entry_set_text (GTK_ENTRY (entry1), "Please enter pin number"); 
   }
   else if (first_click ==1)
   {
   	flags_changesPass=1;
   	gtk_entry_set_text (GTK_ENTRY (entry1), "Enter new password:");  
   }      
       
     return TRUE;
}


/**This function is to called when user presses button to make withdrawal money into their account.
 * @param *button_Deposit GtkButton which allow pressed by user to make transaction
 * @param entry1 gpointer to display instruction 
 */
static gboolean withdraw_function (GtkButton *button_Withdraw, gpointer entry1)
{ 
   if (first_click ==0)
   {
	gtk_entry_set_text (GTK_ENTRY (entry1), "Please enter pin number"); 
   }
   else if (first_click ==1)
   {
   	gtk_entry_set_text (GTK_ENTRY (entry1), "Enter withdraw amount:"); 
   	flags_Withdraw=1;
   }

   return TRUE;
}







