/**This program is to make a hangman game using GTK programming as an interface.
  *The program will use GtkWidget of GtkLabel, GtkImage, GtkButton, GtkEntry and GtkWindow to show the hangman game to user.
  * @author Nur Syahidah binti Azhari Effendi
  * @version 1.0
  * @file hm.c
  */
  
#include <string.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sqlite3.h>

#define BUFFER 4096
#define MAX_IMAGES 8

sqlite3 *db1;

GtkWidget *window;
GtkWidget *vbox;
GtkWidget *entry;
GtkWidget *table;

GtkWidget *playername;

GtkWidget *button[25];

GtkWidget *button1;
GtkWidget *button2;
GtkWidget *button3;

GtkWidget *image;
GtkWidget *image0;
GtkWidget *image1;
GtkWidget *image2;
GtkWidget *image3;
GtkWidget *image4;
GtkWidget *image5;
GtkWidget *image6;

GtkWidget *label; //score
GtkWidget *label1; //category
GtkWidget *label2; //player name
GtkWidget *label3; //empty
GtkWidget *label4; //empty

GtkWidget *dialog; // pop up select category
GtkWidget *dialog2; // pop up GAME OVER
GtkWidget *dialog3; // pop up YOU WON
GtkWidget *dialog4; // pop up player found

char randomname[10]; //selected random name
char randomcategory[2]; //selected random category
char showstring[10]; //the textentry widget string
int wrongcount = 0;
const gchar *entry_text, str[30],*playername_text;


/**
  Standard callback function used to display the results sqlite3
  */
static int callback (void *NotUsed, int argc, char **argv, char **azColName)
{
    NotUsed = 0;
    int i;
    for (i = 0; i < argc; i++)
    {
		printf ("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");	
		strcpy(randomname,argv[i]);
    }
    printf ("\n");
    return 0;
}


/**
  This function sets up the database name and table
  */
void setup_tables()
{
 	int rc1;
    char *zErrMsg = 0;
    char sql_query[BUFFER];
    
	rc1 = sqlite3_open ("hangman.sqlite", &db1);
    if (rc1)
    {
		fprintf (stderr, "Can't open database: %s\n", sqlite3_errmsg (db1));
		sqlite3_close (db1);
		exit (1);
    }
    strcpy(sql_query, "create table allcategories (category,name)");
    rc1 = sqlite3_exec (db1, sql_query, callback, 0, &zErrMsg);
}


/**
  This function will return a random element from choosen category.
  */
void get_random_element(char *category)
{
	char sql_query[BUFFER];
	char *zErrMsg = 0;
	int rc;
	
	sprintf(sql_query,"select name from allcategories where category = '%s' ORDER BY RANDOM() LIMIT 1",category);
	rc = sqlite3_exec (db1, sql_query, callback, 0, &zErrMsg);
	if (rc != SQLITE_OK)
	{
		fprintf (stderr, "SQL error: %s\n", zErrMsg);
		if (zErrMsg)
		    sqlite3_free (zErrMsg);
	}
}


void enter_callback(GtkWidget *widget, GtkWidget *entry)
{
  	entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  	strcpy((char *)str,(char *)entry_text);
  	printf("entry_text: %s\n", entry_text);
}


void playername_callback(GtkWidget *widget, GtkWidget *entry)
{
  	playername_text = gtk_entry_get_text(GTK_ENTRY(entry));
  	//strcpy((char *)str,(char *)playername);
  	printf("playername_text: %s\n", playername_text);
}


/**
  This function will update the text entry
  */
int update_entryText(char ch)
{
	int i;
	int flag = 0;
	for(i = 0; i < strlen(randomname); i++)
	{
		if(randomname[i] == ch)
		{
			showstring[i] = ch;
			flag = 1;
		}
	}
	return flag;
}


/**
  This function will display and hide image depents on number of wrongcount
  */
void set_images(int wrongcount)
{
	if(wrongcount == 0)
	{
		gtk_widget_hide (image1);
        gtk_widget_hide (image2);
        gtk_widget_hide (image3);
        gtk_widget_hide (image4);
        gtk_widget_hide (image5);
        gtk_widget_hide (image6);
        
        gtk_widget_show (image0);       
	}
    if(wrongcount == 1)
    {
    	gtk_widget_hide (image0);
        gtk_widget_hide (image2);
        gtk_widget_hide (image3);
        gtk_widget_hide (image4);
        gtk_widget_hide (image5);
        gtk_widget_hide (image6);
            
        gtk_widget_show (image1);       
    }
    if(wrongcount == 2)
	{
		gtk_widget_hide (image1);
        gtk_widget_hide (image0);
        gtk_widget_hide (image3);
        gtk_widget_hide (image4);
        gtk_widget_hide (image5);
        gtk_widget_hide (image6);
            
        gtk_widget_show (image2);       
	}
	if(wrongcount == 3)
	{
		gtk_widget_hide (image1);
	    gtk_widget_hide (image2);
        gtk_widget_hide (image0);
        gtk_widget_hide (image4);
        gtk_widget_hide (image5);
        gtk_widget_hide (image6);
               
    	gtk_widget_show (image3);       
	}
	if(wrongcount == 4)
    {
		gtk_widget_hide (image1);
        gtk_widget_hide (image2);
        gtk_widget_hide (image3);
        gtk_widget_hide (image0);
	    gtk_widget_hide (image5);
        gtk_widget_hide (image6);
              
        gtk_widget_show (image4);       
	}
    if(wrongcount == 5)
    {
    	gtk_widget_hide (image1);
    	gtk_widget_hide (image2);
        gtk_widget_hide (image3);
        gtk_widget_hide (image4);
        gtk_widget_hide (image0);
        gtk_widget_hide (image6);
              
        gtk_widget_show (image5);       
	}
	if(wrongcount == 6)
	{
		gtk_widget_hide (image1);
        gtk_widget_hide (image2);
        gtk_widget_hide (image3);
        gtk_widget_hide (image4);
        gtk_widget_hide (image5);
        gtk_widget_hide (image0);
               
        gtk_widget_show (image6);       
	}
}


/**
  This function will display and update score from text file scorefile.txt
  */
void update_score(int score)
{	
    FILE *sample_file;
    char name[100];
    char filetext[BUFFER];
    char temp[100];
    int prevscore;
    
    sample_file = fopen("scorefile.txt", "r");  
    printf("HERE \n");
    if(sample_file == NULL)
    {
		fprintf(stderr, "Cant open file for writing\n");
		perror("");
		exit(EXIT_FAILURE);
    }
    
    int flag = 0;
	while(fscanf(sample_file, "%s %d\n",name,&prevscore) > 0)
	{
		printf("%s --> %d\n", name, prevscore);
		if(strcmp(name,gtk_entry_get_text(GTK_ENTRY(playername))) == 0)
		{
			//popup a window "player found"
			//dialog4 = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "player found");
			//gtk_dialog_run (GTK_DIALOG (dialog4));
			//gtk_widget_destroy (dialog4);		
			
			printf("match found and score is updated either 100(won) and 0(lose)\n");
			sprintf(temp,"%s %d\n",name,score);	
			strcat(filetext,temp);	
			flag = 1;
			continue;
		}
	sprintf(temp,"%s %d\n", name, prevscore);	
	strcat(filetext, temp);	
	}
	
	if(flag == 0)//player "not found"
	{
		printf("match not found\n");
		sprintf(temp,"%s %d\n",gtk_entry_get_text(GTK_ENTRY(playername)), score);
		strcat(filetext, temp);	
	}
	//fclose(sample_file);
    sample_file = fopen("scorefile.txt", "w");
    fprintf(sample_file,"%s",filetext);
    fclose(sample_file);
    gtk_label_set_text((GtkLabel *)label, filetext);
}


/**
  This function will pop up a GAME OVER msg and YOU WON msg and change the hangman picture arcording to worgcount
  */
void win_or_loose(int res)
{		 
	if(res == 0)
 	{
		wrongcount++; //increase wrongcount
 		set_images(wrongcount); //change the hangman picture
 			 
		printf("WrongCount:%d \n",wrongcount);
 		if(wrongcount == 6)
 		{
 			printf("GAME OVER\n");
 			
 			//update score 
 			update_score(0);
 			
 			//unlock the player field
 			gtk_entry_set_editable(GTK_ENTRY(playername), 1);
 			
 			wrongcount = 0;
 			set_images(MAX_IMAGES);
 			//pop up a msg dialog
            dialog2 = gtk_message_dialog_new (NULL,GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "GAME OVER!!!");
			gtk_dialog_run (GTK_DIALOG (dialog2));
			gtk_widget_destroy (dialog2);
			gtk_entry_set_text(GTK_ENTRY (entry), "Select A Category..."); 		
 			//set_images(0);
 			
 			//change the hangman picture
            char filename[10];
            sprintf(filename,"hangman%d.png", wrongcount);
            image = gtk_image_new_from_file(filename);
		}	
 	}
 	else //character found
 	{
		gtk_entry_set_text(GTK_ENTRY (entry), showstring);
		if(strcmp(showstring, randomname) == 0) //no more alphabet to be shown player won and pop up msg u won
		{
	        printf("YOU WON\n");
	        //update score 
	        update_score(100);
	        
	        //unlock the player field
 			gtk_entry_set_editable(GTK_ENTRY(playername), 1);
 			
	        
			wrongcount = 0;
			//pop up a msg dialog
       		dialog3 = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "YOU WON!!!");
       		gtk_dialog_run (GTK_DIALOG (dialog3));
       		gtk_widget_destroy (dialog3);
       		gtk_entry_set_text(GTK_ENTRY (entry), "Select A Category..."); 		
            
            //change the hangman picture
            //char filename[10];
            //sprintf(filename,"hangman%d.png", wrongcount);
            //image = gtk_image_new_from_file(filename);
            set_images(0);
 		}		
 	}
}


/**
  This funtion is taken action when 'A' are clicked.
  */
gint action_button_a(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("A clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
 		gtk_dialog_run (GTK_DIALOG (dialog));
 		gtk_widget_destroy (dialog);
 		return FALSE;
 	}
 	int res = update_entryText('a');
 	win_or_loose(res);
 	return FALSE;
}


/** 
This funtion is taken action when 'B' are clicked.
 */
gint action_button_b(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("B clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...")==0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
       	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
 	int res = update_entryText('b');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'C' are clicked.
  */
gint action_button_c(GtkWidget *widget, GdkEvent *event, gpointer value)
{
	printf("C clicked\n");
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('c');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'D' are clicked.
  */
gint action_button_d(GtkWidget *widget,GdkEvent *event, gpointer value)
{
  	printf("D clicked\n");
  	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('d');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'E' are clicked.
  */
gint action_button_e(GtkWidget *widget, GdkEvent *event, gpointer value)
{  
 	printf("E clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('e');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'F' are clicked.
  */
gint action_button_f(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("F clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('f');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'G' are clicked.
  */
gint action_button_g(GtkWidget *widget,GdkEvent *event, gpointer value)
{
 	printf("G clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('g');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'H' are clicked.
  */
gint action_button_h(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("H clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('h');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'I' are clicked.
  */
gint action_button_i(GtkWidget *widget, GdkEvent *event, gpointer value)
{
	printf("I clicked\n");
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('i');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'J' are clicked.
  */
gint action_button_j(GtkWidget *widget, GdkEvent *event, gpointer value)
{
	printf("J clicked\n");
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('j');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'K' are clicked.
  */
gint action_button_k(GtkWidget *widget, GdkEvent *event, gpointer value)
{
	printf("K clicked\n");
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('k');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'L' are clicked.
  */
gint action_button_l(GtkWidget *widget,GdkEvent *event,gpointer value)
{
	printf("L clicked\n");
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('l');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'M' are clicked.
  */
gint action_button_m(GtkWidget *widget,GdkEvent *event, gpointer value)
{    
	printf("M clicked\n");
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('m');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'N' are clicked.
  */
gint action_button_n(GtkWidget *widget,GdkEvent *event,gpointer value)
{
	printf("N clicked\n");
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('n');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'O' are clicked.
  */
gint action_button_o(GtkWidget *widget,GdkEvent *event, gpointer value)
{
	printf("O clicked\n");
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('o');
 	win_or_loose(res);
 	return FALSE;
}


/**
  This funtion is taken action when 'P' are clicked
  */
gint action_button_p(GtkWidget *widget, GdkEvent *event, gpointer value)
{
  	printf("P clicked\n");
  	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('p');
 	win_or_loose(res);
 	return FALSE;
}


/**
  *This funtion is taken action when 'Q' are clicked.
  */
gint action_button_q(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("Q clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('q');
 	win_or_loose(res);
 	return FALSE;
}


/**
  *This funtion is taken action when 'R' are clicked.
  */
gint action_button_r(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("R clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('r');
 	win_or_loose(res);
 	return FALSE;
}


/**
  *This funtion is taken action when 'S' are clicked.
  */
gint action_button_s(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("S clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('s');
 	win_or_loose(res);
 	return FALSE;
}


/**
  *This funtion is taken action when 'T' are clicked.
 **/
gint action_button_t(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("T clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('t');
 	win_or_loose(res);
 	return FALSE;
}


/**
  *This funtion is taken action when 'U' are clicked.
  */
gint action_button_u(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("U clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('u');
 	win_or_loose(res);
 	return FALSE;
}

/**
  *This funtion is taken action when 'V' are clicked.
  */
gint action_button_v(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("V clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('v');
 	win_or_loose(res);
 	return FALSE;
}


/**
  *This funtion is taken action when 'W' are clicked.
  */
gint action_button_w(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("W clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('w');
 	win_or_loose(res);
 	return FALSE;
}


/**
  *This funtion is taken action when 'X' are clicked.
  */
gint action_button_x(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("X clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('x');
 	win_or_loose(res);
 	return FALSE;
}


/**
  *This funtion is taken action when 'Y' are clicked.
  */
gint action_button_y(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("Y clicked\n");
 	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('y');
 	win_or_loose(res);
 	return FALSE;
}


/**
  *This funtion is taken action when 'Z' are clicked.
  */
gint action_button_z(GtkWidget *widget, GdkEvent *event, gpointer value)
{
 	printf("Z clicked\n");
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"Select A Category...") == 0)
 	{
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "Select category to get started");
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box Select a category\n");
 		return FALSE;
 	}
	int res = update_entryText('z');
 	win_or_loose(res);
 	return FALSE;
}

gint popup_box(char *message)
{
	
 		//pop up a msg dialog
 		dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, message);
    	gtk_dialog_run (GTK_DIALOG (dialog));
    	gtk_widget_destroy (dialog);
 		printf("Pop up a dialog box\n");
 		return FALSE;
}
/**
  *This funtion is taken action when 'country' are clicked.
  */
gint action_button_country(GtkWidget *widget, GdkEvent *event, gpointer value)
{
	wrongcount = 0;	
	set_images(wrongcount);
	char popstring[100];
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(playername)),"") == 0)
 	{
 		strcpy(popstring,"Enter Name plzzz");
 		popup_box(popstring);
 		return FALSE;
 	}
	
	//lock the name field
	gtk_entry_set_editable(GTK_ENTRY(playername), 0);
	
	
    strcpy(randomcategory,"c");
 	printf("COUNTRY clicked\n");
 	//select a random COUNTRY
 	get_random_element(randomcategory);
 	int length = strlen(randomname);
 	
 	int i;
 	for(i = 0; i < length; i++)
 		showstring[i] = '*';	
 	showstring[length] = '\0';
	gtk_entry_set_text(GTK_ENTRY (entry), showstring);	
 	return FALSE;
}


/**
  *This funtion is taken action when 'animal' are clicked.
  */
gint action_button_animal(GtkWidget *widget, GdkEvent *event, gpointer value)
{
	wrongcount = 0;	
	set_images(wrongcount);
	
	
	char popstring[100];
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(playername)),"") == 0)
 	{
 		strcpy(popstring,"Enter Name plzzz");
 		popup_box(popstring);
 		return FALSE;
 	}
	
	//lock the name field
	gtk_entry_set_editable(GTK_ENTRY(playername), 0);
	
	
	
    strcpy(randomcategory,"a");
 	printf("ANIMAL clicked\n");
 	//select a random COUNTRY
 	get_random_element(randomcategory);
 	int length = strlen(randomname);
 	
 	int i;
 	for(i = 0; i < length; i++)
 		showstring[i] = '#';	
 	showstring[length] = '\0';
	gtk_entry_set_text(GTK_ENTRY (entry), showstring);	
 	return FALSE;
}


/**
  *This funtion is taken action when 'fruit' are clicked.
  */
gint action_button_fruit(GtkWidget *widget, GdkEvent *event, gpointer value)
{
	wrongcount = 0;	
	set_images(wrongcount);
	
	
	char popstring[100];
	if(strcmp(gtk_entry_get_text(GTK_ENTRY(playername)),"") == 0)
 	{
 		strcpy(popstring,"Enter Name plzzz");
 		popup_box(popstring);
 		return FALSE;
 	}
	
	//lock the name field
	gtk_entry_set_editable(GTK_ENTRY(playername), 0);
	
	
    strcpy(randomcategory,"f");
 	printf("FRUIT clicked\n");
 	//select a random COUNTRY
 	get_random_element(randomcategory);
 	int length = strlen(randomname);
 	
 	int i;
 	for(i = 0; i < length; i++)
 		showstring[i] = '$';	
 	showstring[length] = '\0';
	gtk_entry_set_text(GTK_ENTRY (entry), showstring);	
 	return FALSE;
}


/** This is where program execution starts. All arguments are passed
 * to gtk for processing, which removes any arguments relevant to it.
 * @param argc Number of arguments passed.
 * @param argv NULL terminated array of command line arguments.
 */
int main( int argc, char *argv[])
{
	//SQLITE initialization
	setup_tables();
	
	gtk_init(&argc, &argv);	
 	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size(GTK_WINDOW(window), 340, 200);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	
 	entry_text = (gchar *)malloc(30);
 	entry = gtk_entry_new ();
 	gtk_entry_set_max_length(GTK_ENTRY(entry), 30);
	//The handler will be called before the default handler of the signal
 	g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK (enter_callback), (gpointer)entry);
 	gtk_entry_set_text(GTK_ENTRY (entry), "Select A Category...");
 	gtk_entry_set_editable(GTK_ENTRY(entry), 0);
 	gtk_widget_show (entry);
 	
 	vbox = gtk_vbox_new(FALSE,0);
	
	playername_text = (gchar *)malloc(30);
	playername = gtk_entry_new ();
 	gtk_entry_set_max_length(GTK_ENTRY(playername), 30);
 	g_signal_connect(G_OBJECT(playername), "activate", G_CALLBACK (playername_callback), (gpointer)playername);
 	gtk_widget_show (playername);
 	
	table = gtk_table_new(2, 13, TRUE); 
 	gtk_window_set_title(GTK_WINDOW(window), "-----------------Hangman-----------------");

 	gtk_table_set_row_spacings(GTK_TABLE(table), 4);//Sets the space between every row in table = 5
 	gtk_table_set_col_spacings(GTK_TABLE(table), 4);//Sets the space between every column in table = 5
 
 	button[0] = gtk_button_new_with_label("A");
 	button[1] = gtk_button_new_with_label("B");
 	button[2] = gtk_button_new_with_label("C");
 	button[3] = gtk_button_new_with_label("D");
 	button[4] = gtk_button_new_with_label("E");
 	button[5] = gtk_button_new_with_label("F");
 	button[6] = gtk_button_new_with_label("G");
 	button[7] = gtk_button_new_with_label("H");
 	button[8] = gtk_button_new_with_label("I");
 	button[9] = gtk_button_new_with_label("J");
 	button[10] = gtk_button_new_with_label("K");
 	button[11] = gtk_button_new_with_label("L");
 	button[12] = gtk_button_new_with_label("M");
 	button[13] = gtk_button_new_with_label("N");
 	button[14] = gtk_button_new_with_label("0");
 	button[15] = gtk_button_new_with_label("P");
 	button[16] = gtk_button_new_with_label("Q");
 	button[17] = gtk_button_new_with_label("R");
 	button[18] = gtk_button_new_with_label("S");
 	button[19] = gtk_button_new_with_label("T");
 	button[20] = gtk_button_new_with_label("U");
 	button[21] = gtk_button_new_with_label("V");
 	button[22] = gtk_button_new_with_label("W");
 	button[23] = gtk_button_new_with_label("X");
 	button[24] = gtk_button_new_with_label("Y");
 	button[25] = gtk_button_new_with_label("Z");

	gtk_table_attach_defaults(GTK_TABLE(table), button[0], 0, 1, 0, 1);// a
 	gtk_table_attach_defaults(GTK_TABLE(table), button[13], 0, 1, 1, 2);// n

	gtk_table_attach_defaults(GTK_TABLE(table), button[1], 1, 2, 0, 1);// b
 	gtk_table_attach_defaults(GTK_TABLE(table), button[14], 1, 2, 1, 2);// o

	gtk_table_attach_defaults(GTK_TABLE(table), button[2], 2, 3, 0, 1);// c
 	gtk_table_attach_defaults(GTK_TABLE(table), button[15], 2, 3, 1, 2);// p

	gtk_table_attach_defaults(GTK_TABLE(table), button[3], 3, 4, 0, 1);// d
 	gtk_table_attach_defaults(GTK_TABLE(table), button[16], 3, 4, 1, 2);// q
 	 	
 	gtk_table_attach_defaults(GTK_TABLE(table), button[4], 4, 5, 0, 1);// e
 	gtk_table_attach_defaults(GTK_TABLE(table), button[17], 4, 5, 1, 2);// r
 	
 	gtk_table_attach_defaults(GTK_TABLE(table), button[5], 5, 6, 0, 1);// f
 	gtk_table_attach_defaults(GTK_TABLE(table), button[18], 5, 6, 1, 2);// s
 	
 	gtk_table_attach_defaults(GTK_TABLE(table), button[6], 6, 7, 0, 1);// g
 	gtk_table_attach_defaults(GTK_TABLE(table), button[19], 6, 7, 1, 2);// t
 	
 	gtk_table_attach_defaults(GTK_TABLE(table), button[7], 7, 8, 0, 1);// h
 	gtk_table_attach_defaults(GTK_TABLE(table), button[20], 7, 8, 1, 2);// u
 	
 	gtk_table_attach_defaults(GTK_TABLE(table), button[8], 8, 9, 0, 1);// i
 	gtk_table_attach_defaults(GTK_TABLE(table), button[21], 8, 9, 1, 2);// v
 	
 	gtk_table_attach_defaults(GTK_TABLE(table), button[9], 9, 10, 0, 1);// j
 	gtk_table_attach_defaults(GTK_TABLE(table), button[22], 9, 10, 1, 2);// w
 	
 	gtk_table_attach_defaults(GTK_TABLE(table), button[10], 10, 11, 0, 1);// k
 	gtk_table_attach_defaults(GTK_TABLE(table), button[23], 10, 11, 1, 2);// x
 	
 	gtk_table_attach_defaults(GTK_TABLE(table), button[11], 11, 12, 0, 1);// l
 	gtk_table_attach_defaults(GTK_TABLE(table), button[24], 11, 12, 1, 2);// y
 	
 	gtk_table_attach_defaults(GTK_TABLE(table), button[12], 12, 13, 0, 1);// m
 	gtk_table_attach_defaults(GTK_TABLE(table), button[25], 12, 13, 1, 2);// z

	g_signal_connect (G_OBJECT (button[0]),"clicked",G_CALLBACK(action_button_a),NULL);// a
	g_signal_connect (G_OBJECT (button[1]),"clicked",G_CALLBACK(action_button_b),NULL);// b
 	g_signal_connect (G_OBJECT (button[2]),"clicked",G_CALLBACK(action_button_c),NULL);// c
 	g_signal_connect (G_OBJECT (button[3]),"clicked",G_CALLBACK(action_button_d),NULL);// d
 	g_signal_connect (G_OBJECT (button[4]),"clicked",G_CALLBACK(action_button_e),NULL);// e
 	g_signal_connect (G_OBJECT (button[5]),"clicked",G_CALLBACK(action_button_f),NULL);// f
	g_signal_connect (G_OBJECT (button[6]),"clicked",G_CALLBACK(action_button_g),NULL);// g
	g_signal_connect (G_OBJECT (button[7]),"clicked",G_CALLBACK(action_button_h),NULL);// h
 	g_signal_connect (G_OBJECT (button[8]),"clicked",G_CALLBACK(action_button_i),NULL);// i
 	g_signal_connect (G_OBJECT (button[9]),"clicked",G_CALLBACK(action_button_j),NULL);// j
 	g_signal_connect (G_OBJECT (button[10]),"clicked",G_CALLBACK(action_button_k),NULL);// k
 	g_signal_connect (G_OBJECT (button[11]),"clicked",G_CALLBACK(action_button_l),NULL);// l
 	g_signal_connect (G_OBJECT (button[12]),"clicked",G_CALLBACK(action_button_m),NULL);// m
 	g_signal_connect (G_OBJECT (button[13]),"clicked",G_CALLBACK(action_button_n),NULL);// n
	g_signal_connect (G_OBJECT (button[14]),"clicked",G_CALLBACK(action_button_o),NULL);// o
 	g_signal_connect (G_OBJECT (button[15]),"clicked",G_CALLBACK(action_button_p),NULL);// p
 	g_signal_connect (G_OBJECT (button[16]),"clicked",G_CALLBACK(action_button_q),NULL);// q
 	g_signal_connect (G_OBJECT (button[17]),"clicked",G_CALLBACK(action_button_r),NULL);// r
 	g_signal_connect (G_OBJECT (button[18]),"clicked",G_CALLBACK(action_button_s),NULL);// s
 	g_signal_connect (G_OBJECT (button[19]),"clicked",G_CALLBACK(action_button_t),NULL);// t
 	g_signal_connect (G_OBJECT (button[20]),"clicked",G_CALLBACK(action_button_u),NULL);// u
 	g_signal_connect (G_OBJECT (button[21]),"clicked",G_CALLBACK(action_button_v),NULL);// v
 	g_signal_connect (G_OBJECT (button[22]),"clicked",G_CALLBACK(action_button_w),NULL);// w
	g_signal_connect (G_OBJECT (button[23]),"clicked",G_CALLBACK(action_button_x),NULL);// x
 	g_signal_connect (G_OBJECT (button[24]),"clicked",G_CALLBACK(action_button_y),NULL);// y
 	g_signal_connect (G_OBJECT (button[25]),"clicked",G_CALLBACK(action_button_z),NULL);// z

	button1 = gtk_button_new_with_label(">> Countries <<");
	button2 = gtk_button_new_with_label(">> Animals <<");
	button3 = gtk_button_new_with_label(">> Fruits <<");

	g_signal_connect (G_OBJECT (button2),"clicked",G_CALLBACK(action_button_animal),NULL);// animal
	g_signal_connect (G_OBJECT (button1),"clicked",G_CALLBACK(action_button_country),NULL);// country
	g_signal_connect (G_OBJECT (button3),"clicked",G_CALLBACK(action_button_fruit),NULL);// fruit
	
	image0 = gtk_image_new_from_file("hangman0.png");
	image1 = gtk_image_new_from_file("hangman1.png");
	image2 = gtk_image_new_from_file("hangman2.png");
	image3 = gtk_image_new_from_file("hangman3.png");
	image4 = gtk_image_new_from_file("hangman4.png");
	image5 = gtk_image_new_from_file("hangman5.png");
	image6 = gtk_image_new_from_file("hangman6.png");
           	
	label = gtk_label_new("here is the scores....");
	label1 = gtk_label_new("Choose your category");
	label2 = gtk_label_new("Enter your name");
	label3 = gtk_label_new(" ");
	label4 = gtk_label_new(" ");
	
	//Adds child to box, packed with reference to the start of box for entry and tables
	
	gtk_box_pack_start (GTK_BOX (vbox), label4, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), label2, FALSE, FALSE, 0);//Player name
	gtk_box_pack_start (GTK_BOX (vbox), playername, FALSE, FALSE, 0);//Player name
	gtk_box_pack_start (GTK_BOX (vbox), label3, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), label1, FALSE, FALSE, 0);//category
	gtk_box_pack_start (GTK_BOX (vbox), button1, FALSE, FALSE, 0);//Countries
 	gtk_box_pack_start (GTK_BOX (vbox), button2, FALSE, FALSE, 0);//Animals
 	gtk_box_pack_start (GTK_BOX (vbox), button3, FALSE, FALSE, 0);//Fruits
 	gtk_box_pack_start (GTK_BOX (vbox), image0, FALSE, FALSE, 0);
 	gtk_box_pack_start (GTK_BOX (vbox), image1, FALSE, FALSE, 0);
 	gtk_box_pack_start (GTK_BOX (vbox), image2, FALSE, FALSE, 0);
 	gtk_box_pack_start (GTK_BOX (vbox), image3, FALSE, FALSE, 0);
 	gtk_box_pack_start (GTK_BOX (vbox), image4, FALSE, FALSE, 0);
 	gtk_box_pack_start (GTK_BOX (vbox), image5, FALSE, FALSE, 0);
 	gtk_box_pack_start (GTK_BOX (vbox), image6, FALSE, FALSE, 0);
 	
 	gtk_box_pack_start (GTK_BOX (vbox), entry, FALSE, FALSE, 0);
 	gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 0);//alphabet
 	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);//score
 	
 	gtk_container_add(GTK_CONTAINER(window), vbox);
 	
	//The instance on which the signal is emitted and data will be swapped when calling the handler
 	g_signal_connect_swapped(G_OBJECT(window), "destroy",G_CALLBACK(gtk_main_quit), G_OBJECT(window));

 	gtk_widget_show_all(window);
 	set_images(wrongcount);
 	
 	
 	gtk_main();
	return 0;
}

